/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.event.tracking.phase.packet.player;

import java.util.function.BiConsumer;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ServerboundUseItemOnPacket;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SpawnEggItem;
import org.spongepowered.api.block.BlockState;
import org.spongepowered.api.block.transaction.BlockTransactionReceipt;
import org.spongepowered.api.data.type.HandType;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.entity.living.player.server.ServerPlayer;
import org.spongepowered.api.event.CauseStackManager;
import org.spongepowered.api.event.EventContextKeys;
import org.spongepowered.api.event.cause.entity.SpawnType;
import org.spongepowered.api.event.cause.entity.SpawnTypes;
import org.spongepowered.api.world.LocatableBlock;
import org.spongepowered.api.world.server.ServerWorld;
import org.spongepowered.common.bridge.world.TrackedWorldBridge;
import org.spongepowered.common.bridge.world.level.TrackableBlockEventDataBridge;
import org.spongepowered.common.event.tracking.PhaseTracker;
import org.spongepowered.common.event.tracking.TrackingUtil;
import org.spongepowered.common.event.tracking.phase.packet.BasicPacketContext;
import org.spongepowered.common.event.tracking.phase.packet.BasicPacketState;
import org.spongepowered.common.item.util.ItemStackUtil;
import org.spongepowered.common.world.BlockChange;
import org.spongepowered.common.world.server.SpongeLocatableBlockBuilder;

public final class PlaceBlockPacketState
extends BasicPacketState {
    private final BiConsumer<CauseStackManager.StackFrame, BasicPacketContext> BASIC_PACKET_MODIFIER = super.getFrameModifier().andThen((frame, ctx) -> {
        frame.addContext(EventContextKeys.PLAYER_PLACE, ctx.getSpongePlayer().world());
        frame.addContext(EventContextKeys.USED_HAND, ctx.getHandUsed());
        frame.addContext(EventContextKeys.USED_ITEM, ctx.getItemUsedSnapshot());
        frame.pushCause(ctx.getSpongePlayer());
    });

    @Override
    public BiConsumer<CauseStackManager.StackFrame, BasicPacketContext> getFrameModifier() {
        return this.BASIC_PACKET_MODIFIER;
    }

    @Override
    public boolean isInteraction() {
        return true;
    }

    @Override
    public void populateContext(net.minecraft.server.level.ServerPlayer playerMP, Packet<?> packet, BasicPacketContext context) {
        ServerboundUseItemOnPacket placeBlock = (ServerboundUseItemOnPacket)packet;
        ItemStack itemUsed = playerMP.getItemInHand(placeBlock.getHand());
        org.spongepowered.api.item.inventory.ItemStack itemstack = ItemStackUtil.cloneDefensive(itemUsed);
        context.itemUsed(itemstack);
        HandType handType = (HandType)placeBlock.getHand();
        context.handUsed(handType);
    }

    @Override
    public void postBlockTransactionApplication(BasicPacketContext context, BlockChange blockChange, BlockTransactionReceipt transaction) {
        TrackingUtil.associateTrackerToTarget(blockChange, transaction, ((ServerPlayer)context.getPacketPlayer()).uniqueId());
    }

    @Override
    public void appendNotifierToBlockEvent(BasicPacketContext context, TrackedWorldBridge mixinWorldServer, BlockPos pos, TrackableBlockEventDataBridge blockEvent) {
        Player player = PhaseTracker.getCauseStackManager().currentCause().first(Player.class).get();
        BlockState state = ((ServerWorld)((Object)mixinWorldServer)).block(pos.getX(), pos.getY(), pos.getZ());
        LocatableBlock locatable = new SpongeLocatableBlockBuilder().world((ServerWorld)((Object)mixinWorldServer)).position(pos.getX(), pos.getY(), pos.getZ()).state(state).build();
        blockEvent.bridge$setTickingLocatable(locatable);
        blockEvent.bridge$setSourceUserUUID(player.uniqueId());
    }

    @Override
    public Supplier<SpawnType> getSpawnTypeForTransaction(BasicPacketContext context, Entity entityToSpawn) {
        org.spongepowered.api.item.inventory.ItemStack itemStack = context.getItemUsed();
        return itemStack.type() instanceof SpawnEggItem ? SpawnTypes.SPAWN_EGG : SpawnTypes.PLACEMENT;
    }
}

