/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.inventory.lens.impl.comp;

import org.spongepowered.api.item.inventory.Inventory;
import org.spongepowered.common.inventory.adapter.impl.comp.PrimaryPlayerInventoryAdapter;
import org.spongepowered.common.inventory.fabric.Fabric;
import org.spongepowered.common.inventory.lens.impl.AbstractLens;
import org.spongepowered.common.inventory.lens.impl.comp.GridInventoryLens;
import org.spongepowered.common.inventory.lens.impl.comp.HotbarLens;
import org.spongepowered.common.inventory.lens.impl.slot.SlotLensProvider;
import org.spongepowered.common.inventory.lens.slots.SlotLens;
import org.spongepowered.common.inventory.property.KeyValuePair;

public class PrimaryPlayerInventoryLens
extends AbstractLens {
    private static final int MAIN_INVENTORY_HEIGHT = 3;
    private static final int INVENTORY_WIDTH = 9;
    private HotbarLens hotbar;
    private GridInventoryLens mainGrid;
    private GridInventoryLens fullGrid;
    private boolean isContainer;

    public PrimaryPlayerInventoryLens(int base, SlotLensProvider slots, boolean isContainer) {
        this(base, PrimaryPlayerInventoryAdapter.class, slots, isContainer);
    }

    public PrimaryPlayerInventoryLens(int base, Class<? extends Inventory> adapterType, SlotLensProvider slots, boolean isContainer) {
        super(base, 36, adapterType);
        this.isContainer = isContainer;
        this.init(slots);
    }

    protected void init(SlotLensProvider slots) {
        int base = this.base;
        if (this.isContainer) {
            this.mainGrid = new GridInventoryLens(base, 9, 3, slots);
            this.hotbar = new HotbarLens(base += 27, 9, slots);
            this.addSpanningChild(this.mainGrid, new KeyValuePair[0]);
            this.addSpanningChild(this.hotbar, new KeyValuePair[0]);
            this.fullGrid = new GridInventoryLens(this.base, 9, 4, slots);
            this.addChild(this.fullGrid, new KeyValuePair[0]);
        } else {
            this.hotbar = new HotbarLens(base, 9, slots);
            this.mainGrid = new GridInventoryLens(base += 9, 9, 3, slots);
            this.addSpanningChild(this.hotbar, new KeyValuePair[0]);
            this.addSpanningChild(this.mainGrid, new KeyValuePair[0]);
            ShiftedSlotProvider shiftedSlots = new ShiftedSlotProvider(slots, 9, 36);
            this.fullGrid = new GridInventoryLens(this.base, 9, 4, shiftedSlots);
            this.addChild(this.fullGrid, new KeyValuePair[0]);
        }
    }

    @Override
    public Inventory getAdapter(Fabric fabric, Inventory parent) {
        return new PrimaryPlayerInventoryAdapter(fabric, this, parent);
    }

    public HotbarLens getHotbar() {
        return this.hotbar;
    }

    public GridInventoryLens getGrid() {
        return this.mainGrid;
    }

    public GridInventoryLens getFullGrid() {
        return this.fullGrid;
    }

    private static class ShiftedSlotProvider
    implements SlotLensProvider {
        private final SlotLensProvider provider;
        private final int shiftBy;
        private final int shiftAt;

        public ShiftedSlotProvider(SlotLensProvider provider, int shiftBy, int shiftAt) {
            this.provider = provider;
            this.shiftBy = shiftBy;
            this.shiftAt = shiftAt;
        }

        @Override
        public SlotLens getSlotLens(int index) {
            if ((index += this.shiftBy) >= this.shiftAt) {
                index -= this.shiftAt;
            }
            return this.provider.getSlotLens(index);
        }
    }
}

