/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.api.minecraft.world.level.block;

import net.minecraft.world.level.block.Rotation;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.util.Angle;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.math.matrix.Matrix4d;

@Mixin(value={Rotation.class})
public abstract class RotationMixin_API
implements org.spongepowered.api.util.rotation.Rotation {
    private @Nullable Angle impl$angle = null;
    private @Nullable Matrix4d impl$rotationMatrix = null;

    @Shadow
    public abstract Rotation shadow$getRotated(Rotation var1);

    @Override
    public org.spongepowered.api.util.rotation.Rotation and(org.spongepowered.api.util.rotation.Rotation rotation) {
        return (org.spongepowered.api.util.rotation.Rotation)this.shadow$getRotated((Rotation)rotation);
    }

    @Override
    public Angle angle() {
        this.lazyInit();
        return this.impl$angle;
    }

    @Override
    public Matrix4d toRotationMatrix() {
        this.lazyInit();
        return this.impl$rotationMatrix;
    }

    private Matrix4d createRotationMatrix(int cos, int sin) {
        return Matrix4d.from((double)cos, (double)0.0, (double)sin, (double)0.0, (double)0.0, (double)1.0, (double)0.0, (double)0.0, (double)(-sin), (double)0.0, (double)cos, (double)0.0, (double)0.0, (double)0.0, (double)0.0, (double)1.0);
    }

    private void lazyInit() {
        if (this.impl$angle == null) {
            if ((Rotation)this == Rotation.CLOCKWISE_90) {
                this.impl$angle = Angle.fromDegrees(90.0);
                this.impl$rotationMatrix = this.createRotationMatrix(0, -1);
            } else if ((Rotation)this == Rotation.CLOCKWISE_180) {
                this.impl$angle = Angle.fromDegrees(180.0);
                this.impl$rotationMatrix = this.createRotationMatrix(-1, 0);
            } else if ((Rotation)this == Rotation.COUNTERCLOCKWISE_90) {
                this.impl$angle = Angle.fromDegrees(270.0);
                this.impl$rotationMatrix = this.createRotationMatrix(0, 1);
            } else {
                this.impl$angle = Angle.fromDegrees(0.0);
                this.impl$rotationMatrix = this.createRotationMatrix(1, 0);
            }
        }
    }
}

