/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.server.dedicated;

import com.mojang.authlib.GameProfile;
import net.minecraft.core.LayeredRegistryAccess;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.RegistryLayer;
import net.minecraft.server.dedicated.DedicatedPlayerList;
import net.minecraft.server.players.PlayerList;
import net.minecraft.world.level.storage.PlayerDataStorage;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.service.permission.PermissionService;
import org.spongepowered.api.service.permission.Subject;
import org.spongepowered.api.util.Tristate;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.common.service.server.permission.SpongePermissionService;

@Mixin(value={DedicatedPlayerList.class})
public abstract class DedicatedPlayerListMixin
extends PlayerList {
    public DedicatedPlayerListMixin(MinecraftServer server, LayeredRegistryAccess<RegistryLayer> registryAccess, PlayerDataStorage playerIo, int maxPlayers) {
        super(server, registryAccess, playerIo, maxPlayers);
    }

    @Inject(method={"isWhiteListed"}, at={@At(value="HEAD")}, cancellable=true)
    private void impl$checkForWhitelistBypassPermission(GameProfile profile, CallbackInfoReturnable<Boolean> ci) {
        if (!this.isUsingWhitelist() || this.getWhiteList().isWhiteListed(profile)) {
            ci.setReturnValue((Object)true);
            return;
        }
        PermissionService permissionService = Sponge.server().serviceProvider().permissionService();
        Subject subject = permissionService.userSubjects().subject(profile.getId().toString()).orElse(null);
        if (subject == null) {
            subject = permissionService.userSubjects().defaults();
        }
        ci.setReturnValue((Object)subject.hasPermission("minecraft.login.bypass-whitelist"));
    }

    @Inject(method={"canBypassPlayerLimit"}, at={@At(value="HEAD")}, cancellable=true)
    private void impl$checkForPlayerLimitBypassPermission(GameProfile profile, CallbackInfoReturnable<Boolean> ci) {
        Tristate tristate;
        PermissionService permissionService = Sponge.server().serviceProvider().permissionService();
        Subject subject = permissionService.userSubjects().subject(profile.getId().toString()).orElse(null);
        if (subject == null) {
            subject = permissionService.userSubjects().defaults();
        }
        if ((tristate = subject.permissionValue("minecraft.login.bypass-player-limit")) == Tristate.UNDEFINED && permissionService instanceof SpongePermissionService) {
            return;
        }
        ci.setReturnValue((Object)tristate.asBoolean());
    }
}

