/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.server.level;

import com.mojang.datafixers.util.Either;
import java.util.concurrent.CompletableFuture;
import net.minecraft.server.level.ChunkHolder;
import net.minecraft.server.level.ChunkMap;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ChunkStatus;
import net.minecraft.world.level.chunk.ImposterProtoChunk;
import net.minecraft.world.level.chunk.LevelChunk;
import org.spongepowered.api.ResourceKey;
import org.spongepowered.api.event.SpongeEventFactory;
import org.spongepowered.api.event.world.chunk.ChunkEvent;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.common.SpongeCommon;
import org.spongepowered.common.accessor.server.level.ChunkMapAccessor;
import org.spongepowered.common.bridge.server.level.ServerLevelBridge;
import org.spongepowered.common.event.ShouldFire;
import org.spongepowered.common.event.tracking.PhaseTracker;
import org.spongepowered.common.util.VecHelper;
import org.spongepowered.math.vector.Vector3i;

@Mixin(value={ChunkHolder.class})
abstract class ChunkHolderMixin {
    ChunkHolderMixin() {
    }

    @Inject(method={"replaceProtoChunk(Lnet/minecraft/world/level/chunk/ImposterProtoChunk;)V"}, at={@At(value="TAIL")})
    private void impl$throwChunkGeneratedEvent(ImposterProtoChunk imposter, CallbackInfo ci) {
        if (!ShouldFire.CHUNK_EVENT_GENERATED) {
            return;
        }
        LevelChunk chunk = imposter.getWrapped();
        Vector3i chunkPos = VecHelper.toVector3i(chunk.getPos());
        ChunkEvent.Generated event = SpongeEventFactory.createChunkEventGenerated(PhaseTracker.getInstance().currentCause(), chunkPos, (ResourceKey)chunk.getLevel().dimension().location());
        SpongeCommon.post(event);
    }

    @Inject(method={"getOrScheduleFuture"}, at={@At(value="HEAD")}, cancellable=true)
    private void impl$onGetOrScheduleFuture(ChunkStatus $$0, ChunkMap chunkMap, CallbackInfoReturnable<CompletableFuture<Either<ChunkAccess, ChunkHolder.ChunkLoadingFailure>>> cir) {
        if (!((ServerLevelBridge)((ChunkMapAccessor)chunkMap).accessor$level()).bridge$isLoaded()) {
            cir.setReturnValue((Object)ChunkHolder.UNLOADED_CHUNK_FUTURE);
        }
    }
}

