/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.server.network;

import net.minecraft.network.Connection;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.status.ClientboundStatusResponsePacket;
import net.minecraft.network.protocol.status.ServerStatus;
import net.minecraft.network.protocol.status.ServerboundStatusRequestPacket;
import net.minecraft.server.network.ServerStatusPacketListenerImpl;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.common.network.status.SpongeStatusClient;
import org.spongepowered.common.network.status.SpongeStatusResponse;

@Mixin(value={ServerStatusPacketListenerImpl.class})
public abstract class ServerStatusPacketListenerImplMixin {
    @Shadow
    @Final
    private static Component DISCONNECT_REASON;
    @Shadow
    @Final
    private ServerStatus status;
    @Shadow
    @Final
    private Connection connection;
    @Shadow
    private boolean hasRequestedStatus;

    @Overwrite
    public void handleStatusRequest(ServerboundStatusRequestPacket packetIn) {
        if (this.hasRequestedStatus) {
            this.connection.disconnect(DISCONNECT_REASON);
        } else {
            this.hasRequestedStatus = true;
            ServerStatus response = SpongeStatusResponse.post(this.status, new SpongeStatusClient(this.connection));
            if (response != null) {
                this.connection.send((Packet)new ClientboundStatusResponsePacket(response));
            } else {
                this.connection.disconnect(null);
            }
        }
    }
}

