/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.world.entity.projectile;

import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.projectile.ThrownTrident;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.common.bridge.world.level.LevelBridge;
import org.spongepowered.common.event.SpongeCommonEventFactory;
import org.spongepowered.common.mixin.core.world.entity.projectile.ProjectileMixin;

@Mixin(value={ThrownTrident.class})
public abstract class ThrownTridentMixin
extends ProjectileMixin {
    @Shadow
    private boolean dealtDamage;

    @Inject(method={"onHitEntity"}, at={@At(value="HEAD")}, cancellable=true)
    private void onProjectileHit(EntityHitResult hitResult, CallbackInfo ci) {
        if (((LevelBridge)this.level).bridge$isFake() || hitResult.getType() == HitResult.Type.MISS) {
            return;
        }
        if (SpongeCommonEventFactory.handleCollideImpactEvent((Entity)((ThrownTrident)this), this.impl$getProjectileSource(), (HitResult)hitResult)) {
            this.shadow$playSound(SoundEvents.TRIDENT_HIT, 1.0f, 1.0f);
            this.dealtDamage = true;
            this.shadow$setDeltaMovement(this.shadow$getDeltaMovement().multiply(-0.01, -0.1, -0.01));
            ci.cancel();
        }
    }
}

