/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.inventory.event.world.inventory;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.NonNullList;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.ContainerListener;
import net.minecraft.world.inventory.ContainerSynchronizer;
import net.minecraft.world.inventory.DataSlot;
import net.minecraft.world.inventory.ResultSlot;
import net.minecraft.world.item.ItemStack;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.spongepowered.api.item.inventory.Container;
import org.spongepowered.api.item.inventory.ItemStackSnapshot;
import org.spongepowered.api.item.inventory.Slot;
import org.spongepowered.api.item.inventory.transaction.SlotTransaction;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.Slice;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.common.SpongeCommon;
import org.spongepowered.common.bridge.world.inventory.container.MenuBridge;
import org.spongepowered.common.bridge.world.inventory.container.TrackedContainerBridge;
import org.spongepowered.common.bridge.world.level.LevelBridge;
import org.spongepowered.common.event.tracking.PhaseContext;
import org.spongepowered.common.event.tracking.PhaseTracker;
import org.spongepowered.common.event.tracking.TrackingUtil;
import org.spongepowered.common.event.tracking.context.transaction.EffectTransactor;
import org.spongepowered.common.event.tracking.context.transaction.ResultingTransactionBySideEffect;
import org.spongepowered.common.event.tracking.context.transaction.TransactionalCaptureSupplier;
import org.spongepowered.common.event.tracking.context.transaction.effect.InventoryEffect;
import org.spongepowered.common.event.tracking.phase.tick.TileEntityTickContext;
import org.spongepowered.common.inventory.adapter.InventoryAdapter;
import org.spongepowered.common.inventory.custom.SpongeInventoryMenu;
import org.spongepowered.common.item.util.ItemStackUtil;

@Mixin(value={AbstractContainerMenu.class})
public abstract class AbstractContainerMenuMixin_Inventory
implements TrackedContainerBridge,
InventoryAdapter {
    @Final
    @Shadow
    private NonNullList<ItemStack> lastSlots;
    @Final
    @Shadow
    public NonNullList<net.minecraft.world.inventory.Slot> slots;
    @Final
    @Shadow
    private List<ContainerListener> containerListeners;
    @Shadow
    private boolean suppressRemoteUpdates;
    @Final
    @Shadow
    private List<DataSlot> dataSlots;
    @Shadow
    @Final
    private NonNullList<ItemStack> remoteSlots;
    @Shadow
    @Nullable
    private ContainerSynchronizer synchronizer;
    private boolean impl$isClicking;
    private boolean impl$captureSuccess = false;

    @Shadow
    protected abstract void shadow$doClick(int var1, int var2, ClickType var3, Player var4);

    @Shadow
    protected abstract void shadow$updateDataSlotListeners(int var1, int var2);

    @Shadow
    protected abstract void shadow$synchronizeDataSlotToRemote(int var1, int var2);

    @Shadow
    protected abstract void shadow$synchronizeCarriedToRemote();

    @Shadow
    public abstract void shadow$sendAllDataToRemote();

    @Override
    public boolean bridge$capturePossible() {
        return this.impl$captureSuccess;
    }

    @Redirect(method={"doClick"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/entity/player/Inventory;setItem(ILnet/minecraft/world/item/ItemStack;)V"), slice=@Slice(from=@At(value="FIELD", target="Lnet/minecraft/world/inventory/ClickType;SWAP:Lnet/minecraft/world/inventory/ClickType;"), to=@At(value="FIELD", target="Lnet/minecraft/world/inventory/ClickType;CLONE:Lnet/minecraft/world/inventory/ClickType;")))
    private void impl$handleUnviewedSlotSwap(Inventory inv, int index, ItemStack newStack) {
        if (!PhaseTracker.SERVER.onSidedThread() || inv.player.inventoryMenu == inv.player.containerMenu || Inventory.isHotbarSlot((int)index)) {
            inv.setItem(index, newStack);
        } else {
            ItemStackSnapshot oldItem = ItemStackUtil.snapshotOf(inv.getItem(index));
            ItemStackSnapshot newItem = ItemStackUtil.snapshotOf(newStack);
            inv.setItem(index, newStack);
            this.impl$captureSwap(index, inv, oldItem, newItem);
        }
    }

    @Redirect(method={"doClick"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/item/ItemStack;split(I)Lnet/minecraft/world/item/ItemStack;"), slice=@Slice(from=@At(value="FIELD", target="Lnet/minecraft/world/inventory/ClickType;SWAP:Lnet/minecraft/world/inventory/ClickType;"), to=@At(value="FIELD", target="Lnet/minecraft/world/inventory/ClickType;CLONE:Lnet/minecraft/world/inventory/ClickType;")))
    private ItemStack impl$handleUnviewedSlotSwap2(ItemStack origin, int splitOff, int $$0, int index, ClickType $$2, Player $$3) {
        Inventory inv = $$3.getInventory();
        if (!PhaseTracker.SERVER.onSidedThread() || inv.player.inventoryMenu == inv.player.containerMenu || Inventory.isHotbarSlot((int)index)) {
            return origin.split(splitOff);
        }
        ItemStackSnapshot oldItem = ItemStackUtil.snapshotOf(origin);
        ItemStack newStack = origin.split(splitOff);
        ItemStackSnapshot newItem = ItemStackUtil.snapshotOf(newStack);
        this.impl$captureSwap(index, inv, oldItem, newItem);
        return newStack;
    }

    @Redirect(method={"doClick"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/inventory/Slot;safeTake(IILnet/minecraft/world/entity/player/Player;)Lnet/minecraft/world/item/ItemStack;", ordinal=0), slice=@Slice(from=@At(value="FIELD", target="Lnet/minecraft/world/inventory/ClickType;THROW:Lnet/minecraft/world/inventory/ClickType;"), to=@At(value="FIELD", target="Lnet/minecraft/world/inventory/ClickType;PICKUP_ALL:Lnet/minecraft/world/inventory/ClickType;")))
    private ItemStack impl$verifyReadOnlyMenu(net.minecraft.world.inventory.Slot slot, int param0, int param1, Player param2) {
        if (!((LevelBridge)param2.level).bridge$isFake() && ((MenuBridge)((Object)this)).bridge$isReadonlyMenu(slot)) {
            ((MenuBridge)((Object)this)).bridge$refreshListeners();
            return ItemStack.EMPTY;
        }
        return slot.safeTake(param0, param1, param2);
    }

    @Redirect(method={"doClick"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/inventory/AbstractContainerMenu;quickMoveStack(Lnet/minecraft/world/entity/player/Player;I)Lnet/minecraft/world/item/ItemStack;"))
    private ItemStack impl$transferStackInSlot(AbstractContainerMenu thisContainer, Player player, int slotId) {
        ItemStack result = thisContainer.quickMoveStack(player, slotId);
        if (((LevelBridge)player.level).bridge$isFake() || player.level.isClientSide || !(thisContainer.getSlot(slotId) instanceof ResultSlot)) {
            return result;
        }
        this.bridge$detectAndSendChanges(true, true);
        PhaseContext<@NonNull ?> context = PhaseTracker.SERVER.getPhaseContext();
        TrackingUtil.processBlockCaptures(context);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Redirect(method={"clicked"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/inventory/AbstractContainerMenu;doClick(IILnet/minecraft/world/inventory/ClickType;Lnet/minecraft/world/entity/player/Player;)V"))
    private void inventory$wrapDoClickWithTransaction(AbstractContainerMenu menu, int slotId, int dragType, ClickType clickType, Player player) {
        if (((LevelBridge)player.level).bridge$isFake() || player.level.isClientSide()) {
            this.shadow$doClick(slotId, dragType, clickType, player);
            return;
        }
        PhaseContext<@NonNull ?> context = PhaseTracker.SERVER.getPhaseContext();
        TransactionalCaptureSupplier transactor = context.getTransactor();
        try (EffectTransactor ignored = transactor.logClickContainer(menu, slotId, dragType, clickType, player);){
            this.impl$isClicking = true;
            this.shadow$doClick(slotId, dragType, clickType, player);
        }
        finally {
            this.impl$isClicking = false;
        }
    }

    @Inject(method={"broadcastFullState"}, at={@At(value="HEAD")}, cancellable=true)
    private void impl$broadcastFullStateWithTransactions(CallbackInfo ci) {
        if (!PhaseTracker.SERVER.onSidedThread()) {
            return;
        }
        this.bridge$detectAndSendChanges(false, false);
        this.impl$broadcastDataSlots(false);
        this.shadow$sendAllDataToRemote();
        this.impl$captureSuccess = true;
        ci.cancel();
    }

    @Inject(method={"broadcastChanges"}, at={@At(value="HEAD")}, cancellable=true)
    private void impl$broadcastChangesWithTransactions(CallbackInfo ci) {
        if (!PhaseTracker.SERVER.onSidedThread()) {
            return;
        }
        this.bridge$detectAndSendChanges(false, true);
        this.impl$captureSuccess = true;
        ci.cancel();
    }

    @Override
    public void bridge$detectAndSendChanges(boolean capture, boolean synchronize) {
        PhaseContext<?> phaseContext = PhaseTracker.SERVER.getPhaseContext();
        if (phaseContext.captureModifiedContainer((AbstractContainerMenu)this)) {
            return;
        }
        SpongeInventoryMenu menu = ((MenuBridge)((Object)this)).bridge$getMenu();
        ArrayList<Integer> changes = new ArrayList<Integer>();
        for (int i = 0; i < this.slots.size(); ++i) {
            net.minecraft.world.inventory.Slot slot = (net.minecraft.world.inventory.Slot)this.slots.get(i);
            ItemStack newStack = slot.getItem();
            ItemStack oldStack = (ItemStack)this.lastSlots.get(i);
            if (ItemStack.matches((ItemStack)oldStack, (ItemStack)newStack)) continue;
            changes.add(i);
        }
        for (Integer i : changes) {
            ItemStack remoteStack;
            net.minecraft.world.inventory.Slot slot = (net.minecraft.world.inventory.Slot)this.slots.get(i.intValue());
            ItemStack newStack = slot.getItem();
            ItemStack oldStack = (ItemStack)this.lastSlots.get(i.intValue());
            if (this.impl$isClicking && menu != null && !menu.onChange(newStack, oldStack, (Container)((Object)this), i, slot)) {
                this.lastSlots.set(i.intValue(), (Object)oldStack.copy());
                this.impl$sendSlotContents(i, oldStack);
                continue;
            }
            this.impl$capture(i, newStack, oldStack);
            if (capture) continue;
            oldStack = newStack.isEmpty() ? ItemStack.EMPTY : newStack.copy();
            this.lastSlots.set(i.intValue(), (Object)oldStack);
            for (ContainerListener listener : this.containerListeners) {
                listener.slotChanged((AbstractContainerMenu)this, i.intValue(), oldStack);
            }
            if (!synchronize || ItemStack.matches((ItemStack)(remoteStack = (ItemStack)this.remoteSlots.get(i.intValue())), (ItemStack)newStack)) continue;
            this.remoteSlots.set(i.intValue(), (Object)newStack.copy());
            if (this.synchronizer == null) continue;
            this.synchronizer.sendSlotChange((AbstractContainerMenu)this, i.intValue(), newStack);
        }
        if (synchronize) {
            this.shadow$synchronizeCarriedToRemote();
            this.impl$broadcastDataSlots(true);
        }
    }

    private void impl$sendSlotContents(Integer i, ItemStack oldStack) {
        for (ContainerListener listener : this.containerListeners) {
            boolean isChangingQuantityOnly = true;
            if (listener instanceof ServerPlayer) {
                isChangingQuantityOnly = this.suppressRemoteUpdates;
                this.suppressRemoteUpdates = false;
            }
            listener.slotChanged((AbstractContainerMenu)this, i.intValue(), oldStack);
            if (!(listener instanceof ServerPlayer)) continue;
            this.suppressRemoteUpdates = isChangingQuantityOnly;
        }
    }

    private void impl$broadcastDataSlots(boolean synchronize) {
        for (int j = 0; j < this.dataSlots.size(); ++j) {
            DataSlot dataSlot = this.dataSlots.get(j);
            if (dataSlot.checkAndClearUpdateFlag()) {
                this.shadow$updateDataSlotListeners(j, dataSlot.get());
            }
            if (!synchronize) continue;
            this.shadow$synchronizeDataSlotToRemote(j, dataSlot.get());
        }
    }

    private void impl$capture(Integer index, ItemStack newStack, ItemStack oldStack) {
        PhaseContext<?> phaseContext = PhaseTracker.SERVER.getPhaseContext();
        if (PhaseTracker.SERVER.onSidedThread() && !phaseContext.isRestoring() && !(phaseContext instanceof TileEntityTickContext)) {
            ItemStackSnapshot oldItem = ItemStackUtil.snapshotOf(oldStack);
            ItemStackSnapshot newItem = ItemStackUtil.snapshotOf(newStack);
            try {
                Slot adapter = this.inventoryAdapter$getSlot(index).get();
                SlotTransaction newTransaction = new SlotTransaction(adapter, oldItem, newItem);
                phaseContext.getTransactor().logSlotTransaction(phaseContext, newTransaction, (AbstractContainerMenu)this);
            }
            catch (IndexOutOfBoundsException e) {
                SpongeCommon.logger().error("SlotIndex out of LensBounds! Did the Container change after creation?", (Throwable)e);
            }
        }
    }

    private void impl$captureSwap(int index, Inventory inv, ItemStackSnapshot oldItem, ItemStackSnapshot newItem) {
        PhaseContext<@NonNull ?> phaseContext = PhaseTracker.SERVER.getPhaseContext();
        TransactionalCaptureSupplier transactor = phaseContext.getTransactor();
        Slot adapter = ((InventoryAdapter)inv.player.getInventory()).inventoryAdapter$getSlot(index).get();
        SlotTransaction newTransaction = new SlotTransaction(adapter, oldItem, newItem);
        transactor.logSlotTransaction(phaseContext, newTransaction, (AbstractContainerMenu)this);
        transactor.pushEffect(new ResultingTransactionBySideEffect(InventoryEffect.getInstance()));
    }
}

