/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.inventory.impl.world.inventory;

import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.core.NonNullList;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.common.bridge.world.inventory.InventoryBridge;
import org.spongepowered.common.inventory.fabric.Fabric;

@Mixin(value={AbstractContainerMenu.class})
public abstract class AbstractContainerMenuMixin_Fabric_Inventory
implements Fabric,
InventoryBridge {
    @Shadow
    @Final
    public NonNullList<Slot> slots;
    @Nullable
    private Set<InventoryBridge> all;

    @Shadow
    public abstract Slot shadow$getSlot(int var1);

    @Shadow
    public abstract void shadow$broadcastChanges();

    @Override
    public Collection<InventoryBridge> fabric$allInventories() {
        if (this.all == null) {
            ImmutableSet.Builder builder = ImmutableSet.builder();
            for (Slot slot : this.slots) {
                if (slot.container == null) continue;
                builder.add((Object)((InventoryBridge)slot.container));
            }
            this.all = builder.build();
        }
        return this.all;
    }

    @Override
    public InventoryBridge fabric$get(int index) {
        if (this.slots.isEmpty()) {
            return null;
        }
        return (InventoryBridge)this.shadow$getSlot((int)index).container;
    }

    @Override
    public ItemStack fabric$getStack(int index) {
        return this.shadow$getSlot(index).getItem();
    }

    @Override
    public void fabric$setStack(int index, ItemStack stack) {
        this.shadow$getSlot(index).set(stack);
    }

    @Override
    public int fabric$getMaxStackSize() {
        return this.fabric$allInventories().stream().map(b -> b.bridge$getAdapter().inventoryAdapter$getFabric()).mapToInt(Fabric::fabric$getMaxStackSize).max().orElse(0);
    }

    @Override
    public int fabric$getSize() {
        return this.slots.size();
    }

    @Override
    public void fabric$clear() {
        for (Slot slot : this.slots) {
            slot.set(ItemStack.EMPTY);
        }
    }

    @Override
    public void fabric$markDirty() {
        this.shadow$broadcastChanges();
    }

    @Override
    public Set<AbstractContainerMenu> fabric$containerMenus() {
        return Set.of((AbstractContainerMenu)this);
    }
}

