/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.movementcheck.server.network;

import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.network.ServerGamePacketListenerImpl;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Constant;
import org.spongepowered.asm.mixin.injection.ModifyConstant;
import org.spongepowered.asm.mixin.injection.Slice;
import org.spongepowered.common.config.SpongeGameConfigs;
import org.spongepowered.common.config.inheritable.WorldConfig;

@Mixin(value={ServerGamePacketListenerImpl.class})
public abstract class ServerGamePacketListenerImplMixin_MovementCheck {
    @Shadow
    public ServerPlayer player;

    @ModifyConstant(method={"handleMovePlayer"}, constant={@Constant(floatValue=100.0f, ordinal=0)}, slice={@Slice(from=@At(value="INVOKE", target="Lnet/minecraft/server/level/ServerPlayer;isFallFlying()Z", ordinal=0), to=@At(value="INVOKE", target="Lnet/minecraft/server/network/ServerGamePacketListenerImpl;isSingleplayerOwner()Z", ordinal=0))})
    private float movementCheck$onMovedTooQuickly(float value) {
        double threshold = ((WorldConfig)SpongeGameConfigs.getForWorld((Level)this.player.level).get()).movementChecks.movedTooQuicklyThreshold;
        if (threshold > 0.0 && ((WorldConfig)SpongeGameConfigs.getForWorld((Level)this.player.level).get()).movementChecks.player.movedTooQuickly) {
            return (float)threshold;
        }
        return Float.NaN;
    }

    @ModifyConstant(method={"handleMovePlayer"}, constant={@Constant(doubleValue=0.0625, ordinal=0)}, slice={@Slice(from=@At(value="INVOKE", target="Lnet/minecraft/server/level/ServerPlayer;isChangingDimension()Z", ordinal=1), to=@At(value="INVOKE", target="Lnet/minecraft/server/level/ServerPlayer;isSleeping()Z", ordinal=1))})
    private double movementCheck$onMovedWronglyCheck(double value) {
        double threshold = ((WorldConfig)SpongeGameConfigs.getForWorld((Level)this.player.level).get()).movementChecks.movedWronglyThreshold;
        if (threshold > 0.0 && ((WorldConfig)SpongeGameConfigs.getForWorld((Level)this.player.level).get()).movementChecks.movedWrongly) {
            return threshold;
        }
        return Double.NaN;
    }

    @ModifyConstant(method={"handleMoveVehicle"}, constant={@Constant(doubleValue=0.0625, ordinal=0)}, slice={@Slice(from=@At(value="INVOKE", target="Lnet/minecraft/world/entity/Entity;move(Lnet/minecraft/world/entity/MoverType;Lnet/minecraft/world/phys/Vec3;)V", ordinal=0), to=@At(value="INVOKE", target="Lnet/minecraft/world/entity/Entity;absMoveTo(DDDFF)V"))})
    private double movementCheck$onVehicleMovedWronglyCheck(double value) {
        double threshold = ((WorldConfig)SpongeGameConfigs.getForWorld((Level)this.player.level).get()).movementChecks.vehicleMovedWronglyThreshold;
        if (threshold > 0.0 && ((WorldConfig)SpongeGameConfigs.getForWorld((Level)this.player.level).get()).movementChecks.movedWrongly) {
            return threshold;
        }
        return Double.NaN;
    }

    @ModifyConstant(method={"handleMoveVehicle"}, constant={@Constant(doubleValue=100.0, ordinal=0)}, slice={@Slice(from=@At(value="INVOKE", target="Lnet/minecraft/world/phys/Vec3;lengthSqr()D", ordinal=0), to=@At(value="INVOKE", target="Lnet/minecraft/server/network/ServerGamePacketListenerImpl;isSingleplayerOwner()Z", ordinal=0))})
    private double movementCheck$onVehicleMovedTooQuicklyCheck(double value) {
        double threshold = ((WorldConfig)SpongeGameConfigs.getForWorld((Level)this.player.level).get()).movementChecks.vehicleMovedTooQuicklyThreshold;
        if (threshold > 0.0 && ((WorldConfig)SpongeGameConfigs.getForWorld((Level)this.player.level).get()).movementChecks.player.vehicleMovedTooQuickly) {
            return threshold;
        }
        return Double.NaN;
    }
}

