/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.tracker.world.entity;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.CombatEntry;
import net.minecraft.world.damagesource.CombatTracker;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.spongepowered.api.event.CauseStackManager;
import org.spongepowered.api.event.EventContextKeys;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.common.accessor.world.damagesource.CombatEntryAccessor;
import org.spongepowered.common.accessor.world.damagesource.CombatTrackerAccessor;
import org.spongepowered.common.bridge.world.level.LevelBridge;
import org.spongepowered.common.event.tracking.PhaseContext;
import org.spongepowered.common.event.tracking.PhaseTracker;
import org.spongepowered.common.event.tracking.context.transaction.EffectTransactor;
import org.spongepowered.common.event.tracking.phase.entity.EntityPhase;
import org.spongepowered.common.event.tracking.phase.tick.EntityTickContext;
import org.spongepowered.common.mixin.tracker.world.entity.EntityMixin_Tracker;

@Mixin(value={LivingEntity.class})
public abstract class LivingEntityMixin_Tracker
extends EntityMixin_Tracker {
    @Shadow
    protected boolean dead;
    @Shadow
    protected int deathScore;
    @Shadow
    protected int lastHurtByPlayerTime;
    @Shadow
    public int deathTime;

    @Shadow
    protected abstract void shadow$tickDeath();

    @Shadow
    protected abstract boolean shadow$shouldDropExperience();

    @Shadow
    protected abstract void shadow$dropFromLootTable(DamageSource var1, boolean var2);

    @Shadow
    protected abstract void shadow$dropEquipment();

    @Shadow
    public abstract CombatTracker shadow$getCombatTracker();

    @Shadow
    @Nullable
    public abstract LivingEntity shadow$getKillCredit();

    @Shadow
    public void shadow$die(DamageSource cause) {
    }

    @Shadow
    protected abstract void shadow$dropAllDeathLoot(DamageSource var1);

    @Shadow
    protected abstract void shadow$createWitherRose(@Nullable LivingEntity var1);

    @Shadow
    public abstract void shadow$swing(InteractionHand var1);

    @Shadow
    protected abstract void shadow$pushEntities();

    @Shadow
    public abstract float shadow$getHealth();

    @Override
    protected void tracker$populateDeathContextIfNeeded(CauseStackManager.StackFrame frame, EntityTickContext context) {
        CombatEntry entry;
        DamageSource source;
        if (!(this.shadow$getHealth() <= 0.0f) && this.deathTime <= 0 && !this.dead) {
            return;
        }
        List<CombatEntry> entries = ((CombatTrackerAccessor)this.shadow$getCombatTracker()).accessor$entries();
        if (!entries.isEmpty() && (source = ((CombatEntryAccessor)(entry = entries.get(entries.size() - 1))).accessor$source()) != null) {
            frame.addContext(EventContextKeys.LAST_DAMAGE_SOURCE, (org.spongepowered.api.event.cause.entity.damage.source.DamageSource)source);
        }
    }

    @Redirect(method={"baseTick()V"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/entity/LivingEntity;tickDeath()V"))
    private void tracker$enterDeathPhase(LivingEntity livingEntity) {
        PhaseTracker instance = PhaseTracker.SERVER;
        if (!instance.onSidedThread()) {
            this.shadow$tickDeath();
            return;
        }
        if (((LevelBridge)this.level).bridge$isFake()) {
            this.shadow$tickDeath();
            return;
        }
        PhaseContext<@NonNull ?> context = instance.getPhaseContext();
        if (!context.doesBlockEventTracking()) {
            this.shadow$tickDeath();
            return;
        }
        try (EffectTransactor ignored = context.getTransactor().ensureEntityDropTransactionEffect((Entity)((LivingEntity)this));){
            this.shadow$tickDeath();
        }
    }

    @Redirect(method={"hurt"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/entity/LivingEntity;die(Lnet/minecraft/world/damagesource/DamageSource;)V"))
    private void tracker$wrapOnDeathWithState(LivingEntity thisEntity, DamageSource cause) {
        PhaseTracker instance = PhaseTracker.SERVER;
        if (!instance.onSidedThread()) {
            return;
        }
        if (((LevelBridge)this.level).bridge$isFake()) {
            return;
        }
        PhaseContext<@NonNull ?> context = instance.getPhaseContext();
        if (!context.doesBlockEventTracking()) {
            return;
        }
        try (EffectTransactor ignored = context.getTransactor().ensureEntityDropTransactionEffect((Entity)((LivingEntity)this));){
            this.shadow$die(cause);
        }
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Redirect(method={"aiStep"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/entity/LivingEntity;pushEntities()V"))
    private void tracker$switchIntoCollisions(LivingEntity livingEntity) {
        if (this.level.isClientSide) {
            this.shadow$pushEntities();
            return;
        }
        try (@NonNull P context = EntityPhase.State.COLLISION.createPhaseContext(PhaseTracker.SERVER).source(livingEntity);){
            ((PhaseContext)context).buildAndSwitch();
            this.shadow$pushEntities();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Redirect(method={"tickEffects"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/effect/MobEffectInstance;tick(Lnet/minecraft/world/entity/LivingEntity;Ljava/lang/Runnable;)Z"))
    private boolean impl$wrapEffectWithFrame(MobEffectInstance instance, LivingEntity thisEntity, Runnable runnable) {
        try {
            PhaseTracker.getInstance().pushCause(instance);
            boolean bl = instance.tick(thisEntity, runnable);
            return bl;
        }
        finally {
            PhaseTracker.getInstance().popCause();
        }
    }
}

