/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.tracker.world.item;

import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.BoneMealItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.state.BlockState;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.common.bridge.world.level.LevelBridge;
import org.spongepowered.common.event.ShouldFire;
import org.spongepowered.common.event.tracking.PhaseContext;
import org.spongepowered.common.event.tracking.PhaseTracker;
import org.spongepowered.common.event.tracking.phase.block.BlockPhase;
import org.spongepowered.common.event.tracking.phase.block.GrowablePhaseContext;

@Mixin(value={BoneMealItem.class})
public abstract class BoneMealItemMixin_Tracker {
    @Redirect(method={"growCrop"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/level/block/BonemealableBlock;performBonemeal(Lnet/minecraft/server/level/ServerLevel;Lnet/minecraft/util/RandomSource;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;)V"), require=0, expect=0)
    private static void tracker$wrapGrowWithPhaseEntry(BonemealableBlock iGrowable, ServerLevel worldIn, RandomSource rand, BlockPos pos, BlockState state, ItemStack stack) {
        if (((LevelBridge)worldIn).bridge$isFake() || !ShouldFire.CHANGE_BLOCK_EVENT_ALL) {
            iGrowable.performBonemeal(worldIn, rand, pos, state);
            return;
        }
        PhaseContext<@NonNull ?> current = PhaseTracker.getInstance().getPhaseContext();
        boolean doesEvent = current.doesBlockEventTracking();
        if (doesEvent) {
            try (GrowablePhaseContext context = BlockPhase.State.GROWING.createPhaseContext(PhaseTracker.SERVER).provideItem(stack).world((Level)worldIn).block(state).pos(pos);){
                context.buildAndSwitch();
                iGrowable.performBonemeal(worldIn, rand, pos, state);
            }
        }
    }
}

