/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.world.level.chunk;

import java.io.DataInput;
import java.io.DataInputStream;
import java.io.IOException;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtIo;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.chunk.storage.RegionFile;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.data.persistence.DataContainer;
import org.spongepowered.api.world.chunk.OfflineChunk;
import org.spongepowered.common.data.persistence.NBTTranslator;
import org.spongepowered.math.vector.Vector3i;

public final class SpongeOfflineChunk
implements OfflineChunk {
    private final CompoundTag nbt;
    private final Vector3i chunkPos;

    public SpongeOfflineChunk(CompoundTag nbt, int cx, int cz) {
        this.nbt = nbt;
        this.chunkPos = new Vector3i(cx, 0, cz);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static @Nullable OfflineChunk of(RegionFile regionFile, ChunkPos pos) {
        try (DataInputStream $$2 = regionFile.getChunkDataInputStream(pos);){
            if ($$2 == null) {
                OfflineChunk offlineChunk = null;
                return offlineChunk;
            }
            CompoundTag chunkNbt = NbtIo.read((DataInput)$$2);
            return new SpongeOfflineChunk(chunkNbt, pos.x, pos.z);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Vector3i chunkPosition() {
        return this.chunkPos;
    }

    @Override
    public int contentVersion() {
        return 2;
    }

    @Override
    public DataContainer toContainer() {
        return NBTTranslator.INSTANCE.translate(this.nbt);
    }
}

