/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.world.server;

import java.util.Optional;
import org.spongepowered.api.ResourceKey;
import org.spongepowered.api.data.persistence.AbstractDataBuilder;
import org.spongepowered.api.data.persistence.DataView;
import org.spongepowered.api.data.persistence.InvalidDataException;
import org.spongepowered.api.data.persistence.Queries;
import org.spongepowered.api.world.server.ServerLocation;

public final class SpongeServerLocationBuilder
extends AbstractDataBuilder<ServerLocation> {
    public SpongeServerLocationBuilder() {
        super(ServerLocation.class, 1);
    }

    @Override
    protected Optional<ServerLocation> buildContent(DataView container) throws InvalidDataException {
        ResourceKey worldKey = container.getResourceKey(Queries.WORLD_KEY).orElseThrow(() -> new InvalidDataException("Missing [" + Queries.WORLD_KEY + "] entry"));
        int x = container.getInt(Queries.POSITION_X).orElseThrow(() -> new InvalidDataException("Missing [" + Queries.POSITION_X + "] entry"));
        int y = container.getInt(Queries.POSITION_Y).orElseThrow(() -> new InvalidDataException("Missing [" + Queries.POSITION_Y + "] entry"));
        int z = container.getInt(Queries.POSITION_Z).orElseThrow(() -> new InvalidDataException("Missing [" + Queries.POSITION_Z + "] entry"));
        return Optional.of(ServerLocation.of(worldKey, x, y, z));
    }
}

