/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.world.storage;

import java.util.Optional;
import java.util.UUID;
import org.spongepowered.api.data.persistence.AbstractDataBuilder;
import org.spongepowered.api.data.persistence.DataBuilder;
import org.spongepowered.api.data.persistence.DataView;
import org.spongepowered.api.data.persistence.InvalidDataException;
import org.spongepowered.common.util.Constants;
import org.spongepowered.common.world.storage.SpongePlayerData;

public final class SpongePlayerDataBuilder
extends AbstractDataBuilder<SpongePlayerData>
implements DataBuilder<SpongePlayerData> {
    public SpongePlayerDataBuilder() {
        super(SpongePlayerData.class, 1);
    }

    @Override
    protected Optional<SpongePlayerData> buildContent(DataView container) throws InvalidDataException {
        if (container.contains(Constants.Entity.Player.UUID, Constants.Sponge.PlayerData.PLAYER_DATA_JOIN, Constants.Sponge.PlayerData.PLAYER_DATA_LAST)) {
            String idString = container.getString(Constants.Entity.Player.UUID).get();
            UUID uniqueId = UUID.fromString(idString);
            long firstJoin = container.getLong(Constants.Sponge.PlayerData.PLAYER_DATA_JOIN).get();
            long lastJoin = container.getLong(Constants.Sponge.PlayerData.PLAYER_DATA_LAST).get();
            SpongePlayerData data = new SpongePlayerData();
            data.setUniqueId(uniqueId);
            data.setFirstJoined(firstJoin);
            data.setLastJoined(lastJoin);
            return Optional.of(data);
        }
        return Optional.empty();
    }
}

