/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.world.volume.buffer.block;

import java.util.Objects;
import java.util.function.Function;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.block.BlockState;
import org.spongepowered.api.block.BlockType;
import org.spongepowered.api.block.BlockTypes;
import org.spongepowered.api.fluid.FluidState;
import org.spongepowered.api.world.schematic.Palette;
import org.spongepowered.api.world.volume.block.BlockVolume;
import org.spongepowered.api.world.volume.stream.StreamOptions;
import org.spongepowered.api.world.volume.stream.VolumeElement;
import org.spongepowered.api.world.volume.stream.VolumeStream;
import org.spongepowered.common.world.volume.SpongeVolumeStream;
import org.spongepowered.common.world.volume.VolumeStreamUtils;
import org.spongepowered.common.world.volume.buffer.block.AbstractBlockBuffer;
import org.spongepowered.common.world.volume.buffer.block.BlockBackingData;
import org.spongepowered.math.vector.Vector3d;
import org.spongepowered.math.vector.Vector3i;

public class ArrayImmutableBlockBuffer
extends AbstractBlockBuffer
implements BlockVolume.Immutable {
    private static final BlockState AIR = (BlockState)BlockTypes.AIR.get().defaultState();
    private final Palette<BlockState, BlockType> palette;
    private final BlockBackingData data;

    ArrayImmutableBlockBuffer(Palette<BlockState, BlockType> palette, BlockBackingData data, Vector3i start, Vector3i size) {
        super(start, size);
        this.data = data;
        this.palette = palette.asImmutable();
    }

    public ArrayImmutableBlockBuffer(Palette<BlockState, BlockType> palette, Vector3i start, Vector3i size, char[] blocks) {
        super(start, size);
        this.data = new BlockBackingData.CharBackingData((char[])blocks.clone());
        this.palette = palette.asImmutable();
    }

    public ArrayImmutableBlockBuffer(Palette.Immutable<BlockState, BlockType> palette, Vector3i blockMin, Vector3i blockSize, BlockBackingData data) {
        super(blockMin, blockSize);
        this.data = data;
        this.palette = palette;
    }

    @Override
    public Palette<BlockState, BlockType> getPalette() {
        return this.palette;
    }

    @Override
    public BlockState block(int x, int y, int z) {
        this.checkRange(x, y, z);
        return this.palette.get(this.data.get(this.getIndex(x, y, z)), Sponge.game()).orElse(AIR);
    }

    @Override
    public FluidState fluid(int x, int y, int z) {
        return this.block(x, y, z).fluidState();
    }

    @Override
    public int highestYAt(int x, int z) {
        return 0;
    }

    public static BlockVolume.Immutable newWithoutArrayClone(Palette<BlockState, BlockType> palette, Vector3i start, Vector3i size, char[] blocks) {
        return new ArrayImmutableBlockBuffer(palette, new BlockBackingData.CharBackingData(blocks), start, size);
    }

    @Override
    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ArrayImmutableBlockBuffer that = (ArrayImmutableBlockBuffer)o;
        return this.palette.equals(that.palette) && this.data.equals(that.data);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.palette, this.data);
    }

    @Override
    public VolumeStream<BlockVolume.Immutable, BlockState> blockStateStream(Vector3i min, Vector3i max, StreamOptions options) {
        VolumeStreamUtils.validateStreamArgs(min, max, this.min(), this.max(), options);
        Stream stateStream = IntStream.rangeClosed(min.x(), max.x()).mapToObj(x -> IntStream.rangeClosed(min.z(), max.z()).mapToObj(z -> IntStream.rangeClosed(min.y(), max.y()).mapToObj(y -> VolumeElement.of(this, () -> this.block(x, y, z), new Vector3d((float)x, (float)y, (float)z)))).flatMap(Function.identity())).flatMap(Function.identity());
        return new SpongeVolumeStream<BlockVolume.Immutable, BlockState>(stateStream, () -> this);
    }
}

