/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.vanilla.client.gui.screen;

import com.mojang.blaze3d.vertex.PoseStack;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import org.spongepowered.common.launch.Launch;
import org.spongepowered.plugin.PluginContainer;
import org.spongepowered.plugin.metadata.PluginMetadata;
import org.spongepowered.vanilla.client.gui.widget.MetadataPanel;
import org.spongepowered.vanilla.client.gui.widget.list.PluginSelectionList;

public final class PluginScreen
extends Screen {
    private final Screen previousScreen;
    private final List<PluginMetadata> metadata;
    private PluginSelectionList selectionList;
    private MetadataPanel contentPanel;
    private EditBox searchField;

    public PluginScreen(Screen previousScreen) {
        super((Component)Component.literal((String)"Plugins"));
        this.previousScreen = previousScreen;
        this.metadata = new ObjectArrayList();
        Collection<PluginContainer> plugins = ((Launch)Launch.instance()).pluginManager().plugins();
        this.metadata.addAll(plugins.stream().map(PluginContainer::metadata).collect(Collectors.toList()));
    }

    protected void init() {
        int listHeight = this.height - 122;
        this.selectionList = new PluginSelectionList(this, 4, 58, 175, listHeight, 26);
        this.contentPanel = new MetadataPanel(this.minecraft, this, this.width - this.selectionList.getWidth() - 12, listHeight, 58, this.selectionList.getRight() + 4);
        this.selectionList.setSelectConsumer(e -> this.contentPanel.setMetadata(e == null ? null : e.metadata));
        this.generateEntries(((Launch)Launch.instance()).pluginManager().plugins().stream().map(PluginContainer::metadata).collect(Collectors.toList()));
        this.searchField = new EditBox(this.font, this.width / 2 - 100, 22, 200, 20, (Component)Component.translatable((String)I18n.get((String)"itemGroup.search", (Object[])new Object[0])));
        this.searchField.setResponder(value -> this.selectionList.setFilterSupplier(() -> {
            List filteredList = this.selectionList.children().stream().filter(entry -> entry.metadata.name().orElse("").toLowerCase(Locale.ROOT).contains(value.toLowerCase(Locale.ROOT)) || entry.metadata.id().toLowerCase(Locale.ROOT).contains(value.toLowerCase(Locale.ROOT))).collect(Collectors.toList());
            if (!filteredList.contains(this.selectionList.getSelected())) {
                this.selectionList.setSelected(filteredList.stream().findFirst().orElse(null));
            }
            return filteredList;
        }));
        this.addRenderableWidget((GuiEventListener)this.selectionList);
        this.addRenderableWidget((GuiEventListener)this.contentPanel);
        this.addRenderableWidget((GuiEventListener)this.searchField);
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.translatable((String)I18n.get((String)"gui.done", (Object[])new Object[0])), b -> Minecraft.getInstance().setScreen(this.previousScreen)).pos(this.width / 2 - 50, this.height - 40).size(100, 20).build());
    }

    public void render(PoseStack stack, int p_render_1_, int p_render_2_, float p_render_3_) {
        this.renderBackground(stack);
        super.render(stack, p_render_1_, p_render_2_, p_render_3_);
        Screen.drawCenteredString((PoseStack)stack, (Font)this.font, (String)this.title.getString(), (int)(this.width / 2), (int)8, (int)0xFFFFFF);
    }

    private void generateEntries(List<PluginMetadata> metadatas) {
        if (this.selectionList == null) {
            return;
        }
        this.selectionList.children().clear();
        this.selectionList.children().addAll(metadatas.stream().map(metadata -> new PluginSelectionList.Entry(this.selectionList, (PluginMetadata)metadata)).collect(Collectors.toList()));
        this.selectionList.setSelected(this.selectionList.children().stream().findFirst().orElse(null));
    }
}

