/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.api.util.weighted;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.StringJoiner;
import java.util.random.RandomGenerator;
import org.spongepowered.api.util.weighted.RandomObjectTable;

public class LootTable<T> {
    private final List<RandomObjectTable<T>> pool = new ArrayList<RandomObjectTable<T>>();

    public void addTable(RandomObjectTable<T> table) {
        this.pool.add(Objects.requireNonNull(table));
    }

    public void addAll(LootTable<T> other) {
        this.pool.addAll(other.pool);
    }

    public boolean removeTable(RandomObjectTable<T> table) {
        return this.pool.remove(table);
    }

    public List<RandomObjectTable<T>> tables() {
        return List.copyOf(this.pool);
    }

    public void clearPool() {
        this.pool.clear();
    }

    public List<T> get(RandomGenerator rand) {
        ArrayList<T> results = new ArrayList<T>();
        for (RandomObjectTable<T> pool : this.pool) {
            results.addAll(pool.get(rand));
        }
        return results;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LootTable)) {
            return false;
        }
        LootTable c = (LootTable)o;
        if (this.pool.size() != c.pool.size()) {
            return false;
        }
        for (int i = 0; i < this.pool.size(); ++i) {
            if (this.pool.get(i).equals(c.pool.get(i))) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int r = 1;
        for (RandomObjectTable<T> table : this.pool) {
            r = r * 37 + table.hashCode();
        }
        return r;
    }

    public String toString() {
        return new StringJoiner(", ", LootTable.class.getSimpleName() + "[", "]").add("pool=" + this.pool).toString();
    }
}

