/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.command.parameter.managed.factory;

import com.mojang.brigadier.ImmutableStringReader;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import net.minecraft.network.chat.Component;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.command.parameter.CommandContext;
import org.spongepowered.api.command.parameter.managed.ValueParameter;
import org.spongepowered.api.command.parameter.managed.standard.VariableValueParameters;
import org.spongepowered.api.registry.DefaultedRegistryType;
import org.spongepowered.api.registry.RegistryHolder;
import org.spongepowered.api.registry.RegistryType;
import org.spongepowered.common.command.brigadier.argument.StandardArgumentParser;
import org.spongepowered.common.command.parameter.managed.builder.SpongeDynamicChoicesBuilder;
import org.spongepowered.common.command.parameter.managed.builder.SpongeLiteralBuilder;
import org.spongepowered.common.command.parameter.managed.builder.SpongeNumberRangeBuilder;
import org.spongepowered.common.command.parameter.managed.builder.SpongeRegistryEntryParameterBuilder;
import org.spongepowered.common.command.parameter.managed.builder.SpongeStaticChoicesBuilder;
import org.spongepowered.common.command.parameter.managed.standard.SpongeChoicesValueParameter;

public final class SpongeVariableValueParametersFactory
implements VariableValueParameters.Factory {
    @Override
    public <T extends Enum<T>> @NonNull ValueParameter<T> createEnumParameter(@NonNull Class<T> enumClass) {
        HashMap<String, Supplier<Enum>> choices = new HashMap<String, Supplier<Enum>>();
        for (Enum e : (Enum[])enumClass.getEnumConstants()) {
            choices.put(e.name().toLowerCase(), () -> e);
        }
        return new SpongeChoicesValueParameter(Collections.unmodifiableMap(choices), true, true);
    }

    @Override
    public <T>  @NonNull VariableValueParameters.StaticChoicesBuilder<T> createStaticChoicesBuilder(@NonNull Class<T> returnType) {
        return new SpongeStaticChoicesBuilder();
    }

    @Override
    public <T>  @NonNull VariableValueParameters.DynamicChoicesBuilder<T> createDynamicChoicesBuilder(@NonNull Class<T> returnType) {
        return new SpongeDynamicChoicesBuilder();
    }

    @Override
    public <T>  @NonNull VariableValueParameters.RegistryEntryBuilder<T> createRegistryEntryBuilder(@NonNull RegistryType<T> registryKey) {
        return new SpongeRegistryEntryParameterBuilder<T>(registryKey);
    }

    @Override
    public <T>  @NonNull VariableValueParameters.RegistryEntryBuilder<T> createRegistryEntryBuilder(@NonNull List<Function<CommandContext, @Nullable RegistryHolder>> holderProviders, @NonNull RegistryType<T> type) {
        VariableValueParameters.RegistryEntryBuilder<T> builder = this.createRegistryEntryBuilder(type);
        holderProviders.forEach(builder::addHolderFunction);
        return builder;
    }

    @Override
    public <T>  @NonNull VariableValueParameters.RegistryEntryBuilder<T> createRegistryEntryBuilder(@NonNull DefaultedRegistryType<T> type) {
        SpongeRegistryEntryParameterBuilder<T> builder = new SpongeRegistryEntryParameterBuilder<T>(type);
        builder.addHolderFunction(x -> type.defaultHolder().get());
        return builder;
    }

    @Override
    public <T>  @NonNull VariableValueParameters.LiteralBuilder<T> createLiteralBuilder(@NonNull Class<T> returnType) {
        return new SpongeLiteralBuilder();
    }

    @Override
    public  @NonNull VariableValueParameters.NumberRangeBuilder<@NonNull Integer> createIntegerNumberRangeBuilder() {
        return SpongeNumberRangeBuilder.intBuilder();
    }

    @Override
    public  @NonNull VariableValueParameters.NumberRangeBuilder<@NonNull Float> createFloatNumberRangeBuilder() {
        return SpongeNumberRangeBuilder.floatBuilder();
    }

    @Override
    public  @NonNull VariableValueParameters.NumberRangeBuilder<@NonNull Double> createDoubleNumberRangeBuilder() {
        return SpongeNumberRangeBuilder.doubleBuilder();
    }

    @Override
    public  @NonNull VariableValueParameters.NumberRangeBuilder<@NonNull Long> createLongNumberRangeBuilder() {
        return SpongeNumberRangeBuilder.longBuilder();
    }

    @Override
    public @NonNull ValueParameter<String> createValidatedStringParameter(@NonNull Pattern pattern) {
        Objects.requireNonNull(pattern);
        return StandardArgumentParser.createConverter(StringArgumentType.string(), (reader, contextBuilder, input) -> {
            if (pattern.matcher((CharSequence)input).matches()) {
                return input;
            }
            throw new SimpleCommandExceptionType((Message)Component.literal((String)("Input \"" + input + "\" does not match required pattern \"" + pattern.pattern() + "\""))).createWithContext((ImmutableStringReader)reader);
        });
    }
}

