/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.data.holder;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.data.DataHolder;
import org.spongepowered.api.data.DataProvider;
import org.spongepowered.api.data.Key;
import org.spongepowered.api.data.value.MergeFunction;
import org.spongepowered.api.data.value.Value;
import org.spongepowered.common.data.holder.SpongeDataHolder;

public interface SpongeImmutableDataHolder<I extends DataHolder.Immutable<I>>
extends SpongeDataHolder,
DataHolder.Immutable<I> {
    @Override
    default public <E> Optional<I> transform(Key<? extends Value<E>> key, Function<E, E> function) {
        DataProvider provider = this.impl$getProviderFor(key, this);
        return provider.get(this).flatMap(e -> {
            Object transformed = Objects.requireNonNull(function.apply(e));
            return provider.with(this, transformed);
        });
    }

    @Override
    default public <E> Optional<I> with(Key<? extends Value<E>> key, E value) {
        return this.impl$getProviderFor(key, this).with(this, value);
    }

    @Override
    default public Optional<I> with(Value<?> value) {
        return this.impl$getProviderFor(value.key(), this).with(this, value.get());
    }

    @Override
    default public Optional<I> without(Key<?> key) {
        return this.impl$getProviderFor(key, this).without(this);
    }

    @Override
    default public I mergeWith(I that, MergeFunction function) {
        DataHolder.Immutable<I> result = this;
        if (function == MergeFunction.REPLACEMENT_PREFERRED) {
            for (Value value : that.getValues()) {
                Optional optionalResult = result.with(value);
                if (!optionalResult.isPresent()) continue;
                result = (DataHolder.Immutable)optionalResult.get();
            }
        } else if (function == MergeFunction.ORIGINAL_PREFERRED) {
            for (Value value : that.getValues()) {
                Optional optionalResult;
                if (this.get(value.key()).isPresent() || !(optionalResult = result.with(value)).isPresent()) continue;
                result = (DataHolder.Immutable)optionalResult.get();
            }
        } else {
            for (Value value : that.getValues()) {
                Key key = value.key();
                DataProvider provider = this.impl$getProviderFor(key, this);
                @Nullable Value original = provider.value(this).map(Value::asImmutable).orElse(null);
                Value merged = function.merge(original, value);
                Optional<I> optionalResult = result.with(merged);
                if (!optionalResult.isPresent()) continue;
                result = (DataHolder.Immutable)optionalResult.get();
            }
        }
        return (I)result;
    }
}

