/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.entity.ai.goal.builtin.creature;

import com.google.common.base.Preconditions;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import org.spongepowered.api.entity.ai.goal.builtin.creature.AttackLivingGoal;
import org.spongepowered.api.entity.living.Creature;

public final class SpongeAttackLivingGoalBuilder
implements AttackLivingGoal.Builder {
    private double speed;
    private boolean longMemory;

    public SpongeAttackLivingGoalBuilder() {
        this.reset();
    }

    @Override
    public AttackLivingGoal.Builder speed(double speed) {
        this.speed = speed;
        return this;
    }

    @Override
    public AttackLivingGoal.Builder longMemory() {
        this.longMemory = true;
        return this;
    }

    @Override
    public AttackLivingGoal.Builder from(AttackLivingGoal value) {
        return this.speed(value.speed()).longMemory();
    }

    @Override
    public AttackLivingGoal.Builder reset() {
        this.speed = 0.0;
        this.longMemory = false;
        return this;
    }

    @Override
    public AttackLivingGoal build(Creature owner) {
        Preconditions.checkNotNull((Object)owner);
        return (AttackLivingGoal)new MeleeAttackGoal((PathfinderMob)owner, this.speed, this.longMemory);
    }
}

