/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.event.tracking.context.transaction.inventory;

import java.util.List;
import java.util.Optional;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.crafting.RecipeType;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.spongepowered.api.data.Transaction;
import org.spongepowered.api.entity.Entity;
import org.spongepowered.api.event.Cause;
import org.spongepowered.api.event.SpongeEventFactory;
import org.spongepowered.api.event.item.inventory.CraftItemEvent;
import org.spongepowered.api.event.item.inventory.container.ClickContainerEvent;
import org.spongepowered.api.item.inventory.ItemStackSnapshot;
import org.spongepowered.api.item.inventory.crafting.CraftingInventory;
import org.spongepowered.api.item.inventory.transaction.SlotTransaction;
import org.spongepowered.api.item.recipe.crafting.CraftingRecipe;
import org.spongepowered.common.event.tracking.PhaseContext;
import org.spongepowered.common.event.tracking.context.transaction.TransactionFlow;
import org.spongepowered.common.event.tracking.context.transaction.inventory.ContainerBasedTransaction;
import org.spongepowered.common.inventory.util.ContainerUtil;
import org.spongepowered.common.item.util.ItemStackUtil;

public class CraftingPreviewTransaction
extends ContainerBasedTransaction {
    final Player player;
    final CraftingInventory craftingInventory;
    final CraftingContainer craftSlots;

    public CraftingPreviewTransaction(ServerPlayer player, CraftingInventory craftingInventory, CraftingContainer craftSlots) {
        super(player.containerMenu);
        this.player = player;
        this.craftingInventory = craftingInventory;
        this.craftSlots = craftSlots;
    }

    @Override
    public Optional<TransactionFlow.AbsorbingFlowStep> parentAbsorber() {
        return Optional.of((ctx, tx) -> tx.acceptCraftingPreview(ctx, this));
    }

    @Override
    Optional<ClickContainerEvent> createInventoryEvent(List<SlotTransaction> slotTransactions, List<Entity> entities, PhaseContext<@NonNull ?> context, Cause currentCause) {
        if (slotTransactions.isEmpty()) {
            return Optional.empty();
        }
        ItemStackSnapshot cursor = ItemStackUtil.snapshotOf(this.player.containerMenu.getCarried());
        SlotTransaction previewTransaction = this.getPreviewTransaction(this.craftingInventory.result(), slotTransactions);
        Optional<CraftingRecipe> recipe = this.player.level().getRecipeManager().getRecipeFor(RecipeType.CRAFTING, (Container)this.craftSlots, this.player.level()).map(CraftingRecipe.class::cast);
        CraftItemEvent.Preview event = SpongeEventFactory.createCraftItemEventPreview(currentCause, ContainerUtil.fromNative(this.menu), this.craftingInventory, new Transaction<ItemStackSnapshot>(cursor, cursor), previewTransaction, recipe, Optional.empty(), slotTransactions);
        return Optional.of(event);
    }

    @Override
    public boolean shouldHaveBeenAbsorbed() {
        return false;
    }
}

