/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.event.tracking.context.transaction.world;

import com.google.common.collect.ImmutableList;
import java.lang.ref.WeakReference;
import java.util.Optional;
import java.util.StringJoiner;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.damagesource.CombatEntry;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.entity.Entity;
import org.spongepowered.api.event.Cause;
import org.spongepowered.api.event.CauseStackManager;
import org.spongepowered.api.event.EventContextKeys;
import org.spongepowered.api.event.SpongeEventFactory;
import org.spongepowered.api.event.entity.HarvestEntityEvent;
import org.spongepowered.api.world.server.ServerWorld;
import org.spongepowered.common.accessor.world.damagesource.CombatTrackerAccessor;
import org.spongepowered.common.event.tracking.PhaseContext;
import org.spongepowered.common.event.tracking.context.transaction.GameTransaction;
import org.spongepowered.common.event.tracking.context.transaction.TransactionFlow;
import org.spongepowered.common.event.tracking.context.transaction.type.TransactionTypes;
import org.spongepowered.common.event.tracking.context.transaction.world.WorldBasedTransaction;
import org.spongepowered.common.util.PrettyPrinter;
import org.spongepowered.common.world.volume.VolumeStreamUtils;

public final class EntityPerformingDropsTransaction
extends WorldBasedTransaction<HarvestEntityEvent> {
    private @MonotonicNonNull Supplier<ServerLevel> worldSupplier;
    final net.minecraft.world.entity.Entity destroyingEntity;
    private @MonotonicNonNull CompoundTag entityTag;
    private @MonotonicNonNull Supplier<Optional<DamageSource>> lastAttacker;

    public EntityPerformingDropsTransaction(net.minecraft.world.entity.Entity destroyingEntity) {
        super(TransactionTypes.ENTITY_DEATH_DROPS.get(), ((ServerWorld)destroyingEntity.level()).key());
        this.destroyingEntity = destroyingEntity;
    }

    @Override
    protected void captureState() {
        CombatEntry entry;
        super.captureState();
        net.minecraft.world.entity.Entity entity = this.destroyingEntity;
        this.worldSupplier = VolumeStreamUtils.createWeaklyReferencedSupplier((ServerLevel)entity.level(), "ServerLevel");
        CompoundTag tag = new CompoundTag();
        entity.saveWithoutId(tag);
        this.entityTag = tag;
        @Nullable DamageSource lastAttacker = entity instanceof LivingEntity ? ((entry = ((CombatTrackerAccessor)((LivingEntity)entity).getCombatTracker()).invoker$getMostSignificantFall()) != null ? entry.source() : null) : null;
        WeakReference<@Nullable Object> ref = new WeakReference<Object>(lastAttacker);
        this.lastAttacker = () -> {
            @Nullable DamageSource damageSource = (DamageSource)ref.get();
            if (damageSource == null) {
                return Optional.empty();
            }
            return Optional.of(damageSource);
        };
    }

    @Override
    public Optional<TransactionFlow.AbsorbingFlowStep> parentAbsorber() {
        return Optional.of((ctx, tx) -> tx.acceptEntityDrops(this.destroyingEntity));
    }

    @Override
    public Optional<BiConsumer<PhaseContext<@NonNull ?>, CauseStackManager.StackFrame>> getFrameMutator(@Nullable GameTransaction<@NonNull ?> parent) {
        return Optional.of((context, stackFrame) -> {
            stackFrame.pushCause(this.destroyingEntity);
            this.lastAttacker.get().ifPresent(attacker -> stackFrame.addContext(EventContextKeys.LAST_DAMAGE_SOURCE, (org.spongepowered.api.event.cause.entity.damage.source.DamageSource)attacker));
        });
    }

    @Override
    public void addToPrinter(PrettyPrinter printer) {
    }

    @Override
    public boolean acceptEntityDrops(net.minecraft.world.entity.Entity entity) {
        return this.destroyingEntity == entity;
    }

    @Override
    public boolean isUnbatchable() {
        return true;
    }

    @Override
    public Optional<HarvestEntityEvent> generateEvent(PhaseContext<@NonNull ?> context, @Nullable GameTransaction<@NonNull ?> parent, ImmutableList<GameTransaction<HarvestEntityEvent>> gameTransactions, Cause currentCause) {
        return Optional.of(SpongeEventFactory.createHarvestEntityEvent(currentCause, (Entity)this.destroyingEntity));
    }

    @Override
    public void restore(PhaseContext<?> context, HarvestEntityEvent event) {
        this.destroyingEntity.getType().spawn(this.worldSupplier.get(), this.entityTag, null, this.destroyingEntity.blockPosition(), MobSpawnType.COMMAND, false, false);
    }

    @Override
    public boolean markCancelledTransactions(HarvestEntityEvent event, ImmutableList<? extends GameTransaction<HarvestEntityEvent>> gameTransactions) {
        return false;
    }

    @Override
    public String toString() {
        return new StringJoiner(", ", EntityPerformingDropsTransaction.class.getSimpleName() + "[", "]").add("destroyingEntity=" + this.destroyingEntity).add("lastAttacker=" + this.lastAttacker).add("worldKey=" + this.worldKey).add("cancelled=" + this.cancelled).toString();
    }
}

