/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.event.tracking.phase.packet.player;

import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ServerboundInteractPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.data.Keys;
import org.spongepowered.api.data.type.HandType;
import org.spongepowered.api.entity.Entity;
import org.spongepowered.api.item.inventory.ItemStack;
import org.spongepowered.api.world.World;
import org.spongepowered.common.accessor.network.protocol.game.ServerboundInteractPacketAccessor;
import org.spongepowered.common.accessor.network.protocol.game.ServerboundInteractPacket_InteractionAtLocationActionAccessor;
import org.spongepowered.common.bridge.CreatorTrackedBridge;
import org.spongepowered.common.entity.PlayerTracker;
import org.spongepowered.common.event.tracking.TrackingUtil;
import org.spongepowered.common.event.tracking.phase.packet.BasicPacketContext;
import org.spongepowered.common.event.tracking.phase.packet.BasicPacketState;
import org.spongepowered.common.item.util.ItemStackUtil;

public final class InteractAtEntityPacketState
extends BasicPacketState {
    @Override
    public boolean isPacketIgnored(Packet<?> packetIn, ServerPlayer packetPlayer) {
        ServerboundInteractPacket useEntityPacket = (ServerboundInteractPacket)packetIn;
        @Nullable net.minecraft.world.entity.Entity entity = useEntityPacket.getTarget((ServerLevel)packetPlayer.level());
        return entity == null;
    }

    @Override
    public void populateContext(ServerPlayer playerMP, Packet<?> packet, BasicPacketContext context) {
        ServerboundInteractPacket useEntityPacket = (ServerboundInteractPacket)packet;
        ServerboundInteractPacket_InteractionAtLocationActionAccessor accessor = (ServerboundInteractPacket_InteractionAtLocationActionAccessor)((ServerboundInteractPacketAccessor)useEntityPacket).accessor$action();
        ItemStack stack = ItemStackUtil.cloneDefensive(playerMP.getItemInHand(accessor.accessor$hand()));
        if (stack != null) {
            context.itemUsed(stack);
        }
        HandType handType = (HandType)accessor.accessor$hand();
        context.handUsed(handType);
    }

    @Override
    public void unwind(BasicPacketContext context) {
        ServerPlayer player = context.getPacketPlayer();
        ServerboundInteractPacket useEntityPacket = (ServerboundInteractPacket)context.getPacket();
        net.minecraft.world.entity.Entity entity = useEntityPacket.getTarget((ServerLevel)player.level());
        if (entity == null) {
            return;
        }
        World spongeWorld = (World)player.level();
        if (entity instanceof CreatorTrackedBridge) {
            ((CreatorTrackedBridge)entity).tracker$setTrackedUUID(PlayerTracker.Type.CREATOR, player.getUUID());
        } else {
            ((Entity)entity).offer(Keys.NOTIFIER, player.getUUID());
        }
        TrackingUtil.processBlockCaptures(context);
    }
}

