/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.api.minecraft.server.level;

import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.kyori.adventure.identity.Identity;
import net.kyori.adventure.pointer.Pointers;
import net.minecraft.core.BlockPos;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerChunkCache;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.ProgressListener;
import net.minecraft.world.entity.raid.Raid;
import net.minecraft.world.entity.raid.Raids;
import net.minecraft.world.level.CollisionGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.border.WorldBorder;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.entity.PersistentEntitySectionManager;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.storage.LevelResource;
import net.minecraft.world.level.storage.ServerLevelData;
import net.minecraft.world.ticks.LevelTicks;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import org.jetbrains.annotations.NotNull;
import org.spongepowered.api.ResourceKey;
import org.spongepowered.api.Server;
import org.spongepowered.api.block.BlockSnapshot;
import org.spongepowered.api.block.BlockType;
import org.spongepowered.api.entity.Entity;
import org.spongepowered.api.entity.living.player.server.ServerPlayer;
import org.spongepowered.api.fluid.FluidType;
import org.spongepowered.api.scheduler.ScheduledUpdateList;
import org.spongepowered.api.util.Ticks;
import org.spongepowered.api.world.BlockChangeFlag;
import org.spongepowered.api.world.SerializationBehavior;
import org.spongepowered.api.world.border.WorldBorder;
import org.spongepowered.api.world.chunk.WorldChunk;
import org.spongepowered.api.world.explosion.Explosion;
import org.spongepowered.api.world.generation.ChunkGenerator;
import org.spongepowered.api.world.server.ChunkManager;
import org.spongepowered.api.world.server.ServerLocation;
import org.spongepowered.api.world.server.ServerWorld;
import org.spongepowered.api.world.server.storage.ServerWorldProperties;
import org.spongepowered.api.world.storage.ChunkLayout;
import org.spongepowered.api.world.weather.WeatherType;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.common.accessor.world.entity.raid.RaidsAccessor;
import org.spongepowered.common.bridge.server.level.ServerLevelBridge;
import org.spongepowered.common.bridge.world.level.border.WorldBorderBridge;
import org.spongepowered.common.bridge.world.level.storage.PrimaryLevelDataBridge;
import org.spongepowered.common.data.holder.SpongeServerLocationBaseDataHolder;
import org.spongepowered.common.mixin.api.minecraft.world.level.LevelMixin_API;
import org.spongepowered.common.util.VecHelper;
import org.spongepowered.common.world.storage.SpongeChunkLayout;
import org.spongepowered.math.vector.Vector3d;
import org.spongepowered.math.vector.Vector3i;

@Mixin(value={ServerLevel.class})
public abstract class ServerLevelMixin_API
extends LevelMixin_API<ServerWorld, ServerLocation>
implements ServerWorld,
SpongeServerLocationBaseDataHolder {
    @Shadow
    @Final
    private LevelTicks<Block> blockTicks;
    @Shadow
    @Final
    private LevelTicks<Fluid> fluidTicks;
    @Shadow
    @Final
    private PersistentEntitySectionManager<net.minecraft.world.entity.Entity> entityManager;
    @Shadow
    @Final
    private ServerLevelData serverLevelData;
    private volatile @MonotonicNonNull Pointers api$pointers;

    @Shadow
    public abstract void shadow$save(@Nullable ProgressListener var1, boolean var2, boolean var3);

    @Shadow
    public abstract void shadow$unload(LevelChunk var1);

    @Shadow
    public abstract ServerChunkCache shadow$getChunkSource();

    @Override
    @Nonnull
    @Shadow
    public abstract MinecraftServer shadow$getServer();

    @Nullable
    @Shadow
    public abstract net.minecraft.world.entity.Entity shadow$getEntity(UUID var1);

    @Shadow
    public abstract List<net.minecraft.server.level.ServerPlayer> shadow$players();

    @Shadow
    public abstract Raids shadow$getRaids();

    @Nullable
    @Shadow
    public abstract Raid shadow$getRaidAt(BlockPos var1);

    @Shadow
    public abstract long shadow$getSeed();

    @Override
    public long seed() {
        return this.shadow$getSeed();
    }

    @Override
    public boolean isLoaded() {
        return ((ServerLevelBridge)((Object)this)).bridge$isLoaded();
    }

    @NotNull
    public Pointers pointers() {
        if (this.api$pointers == null) {
            this.api$pointers = (Pointers)Pointers.builder().withDynamic(Identity.UUID, this::uniqueId).withDynamic(Identity.NAME, () -> this.key().formatted()).withDynamic(Identity.DISPLAY_NAME, () -> this.properties().displayName().orElse(null)).build();
            return this.api$pointers;
        }
        return this.api$pointers;
    }

    @Override
    public ServerLocation location(Vector3i position) {
        return ServerLocation.of((ServerWorld)this, Objects.requireNonNull(position, "position"));
    }

    @Override
    public ServerLocation location(Vector3d position) {
        return ServerLocation.of((ServerWorld)this, Objects.requireNonNull(position, "position"));
    }

    @Override
    public ServerWorldProperties properties() {
        return (ServerWorldProperties)this.shadow$getLevelData();
    }

    @Override
    public ChunkGenerator generator() {
        return (ChunkGenerator)this.shadow$getChunkSource().getGenerator();
    }

    @Override
    public ResourceKey key() {
        return (ResourceKey)this.shadow$dimension().location();
    }

    @Override
    public Server engine() {
        return (Server)this.shadow$getServer();
    }

    @Override
    public BlockSnapshot createSnapshot(int x, int y, int z) {
        return ((ServerLevelBridge)((Object)this)).bridge$createSnapshot(x, y, z);
    }

    @Override
    public boolean restoreSnapshot(BlockSnapshot snapshot, boolean force, BlockChangeFlag flag) {
        return snapshot.restore(force, Objects.requireNonNull(flag, "flag"));
    }

    @Override
    public boolean restoreSnapshot(int x, int y, int z, BlockSnapshot snapshot, boolean force, BlockChangeFlag flag) {
        return ((BlockSnapshot)Objects.requireNonNull(snapshot, "snapshot").withLocation((ServerLocation)this.location(x, y, z))).restore(force, Objects.requireNonNull(flag, "flag"));
    }

    @Override
    public Path directory() {
        return ((ServerLevelBridge)((Object)this)).bridge$getLevelSave().getLevelPath(LevelResource.ROOT);
    }

    @Override
    public boolean save() throws IOException {
        SerializationBehavior behavior = ((PrimaryLevelDataBridge)this.serverLevelData).bridge$serializationBehavior().orElse(SerializationBehavior.AUTOMATIC);
        ((ServerLevelBridge)((Object)this)).bridge$setManualSave(true);
        this.shadow$save(null, false, false);
        return !behavior.equals((Object)SerializationBehavior.NONE);
    }

    @Override
    public boolean unloadChunk(WorldChunk chunk) {
        this.shadow$unload((LevelChunk)Objects.requireNonNull(chunk, "chunk"));
        return true;
    }

    @Override
    public void triggerExplosion(Explosion explosion) {
        ((ServerLevelBridge)((Object)this)).bridge$triggerExplosion(Objects.requireNonNull(explosion, "explosion"));
    }

    @Override
    public Collection<ServerPlayer> players() {
        return Collections.unmodifiableCollection(ImmutableList.copyOf(this.shadow$players()));
    }

    public Collection<Entity> entities() {
        Iterable all = this.entityManager.getEntityGetter().getAll();
        List returningList = StreamSupport.stream(all.spliterator(), false).collect(Collectors.toList());
        return Collections.unmodifiableCollection(returningList);
    }

    @Override
    public Collection<org.spongepowered.api.raid.Raid> raids() {
        return ((RaidsAccessor)this.shadow$getRaids()).accessor$raidMap().values();
    }

    @Override
    public Optional<org.spongepowered.api.raid.Raid> raidAt(Vector3i blockPosition) {
        return Optional.ofNullable((org.spongepowered.api.raid.Raid)this.shadow$getRaidAt(VecHelper.toBlockPos(Objects.requireNonNull(blockPosition, "blockPosition"))));
    }

    @Override
    public boolean contains(int x, int y, int z) {
        return ((ServerLevel)this).isInWorldBounds(new BlockPos(x, y, z));
    }

    @Override
    public Optional<Entity> entity(UUID uniqueId) {
        return Optional.ofNullable((Entity)this.shadow$getEntity(Objects.requireNonNull(uniqueId, "uniqueId")));
    }

    @Override
    public void removeBlockEntity(int x, int y, int z) {
        this.blockEntity(x, y, z).ifPresent(ignored -> this.removeBlock(x, y, z));
    }

    @Override
    public ScheduledUpdateList<BlockType> scheduledBlockUpdates() {
        return (ScheduledUpdateList)this.blockTicks;
    }

    @Override
    public ScheduledUpdateList<FluidType> scheduledFluidUpdates() {
        return (ScheduledUpdateList)this.fluidTicks;
    }

    @Override
    public ServerLocation impl$dataholder(int x, int y, int z) {
        return ServerLocation.of((ServerWorld)this, x, y, z);
    }

    @Override
    public void setWeather(WeatherType type) {
        this.properties().setWeather(Objects.requireNonNull(type, "type"));
    }

    @Override
    public void setWeather(WeatherType type, Ticks ticks) {
        this.properties().setWeather(Objects.requireNonNull(type, "type"), Objects.requireNonNull(ticks, "ticks"));
    }

    @Override
    public ChunkLayout chunkLayout() {
        if (this.api$chunkLayout == null) {
            int height = ((ServerLevel)this).getHeight();
            int min = ((ServerLevel)this).getMinBuildHeight();
            this.api$chunkLayout = new SpongeChunkLayout(min, height);
        }
        return this.api$chunkLayout;
    }

    @Override
    public WorldBorder setBorder(WorldBorder border) {
        WorldBorder worldBorder = ((WorldBorderBridge)((CollisionGetter)this).getWorldBorder()).bridge$applyFrom(border);
        if (worldBorder == null) {
            return (WorldBorder)net.minecraft.world.level.border.WorldBorder.DEFAULT_SETTINGS;
        }
        this.serverLevelData.setWorldBorder((WorldBorder.Settings)border);
        return worldBorder;
    }

    @Override
    public ChunkManager chunkManager() {
        return (ChunkManager)this.shadow$getChunkSource().chunkMap;
    }
}

