/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.api.minecraft.world.level.levelgen.structure.templatesystem;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.api.block.BlockType;
import org.spongepowered.api.block.entity.BlockEntityArchetype;
import org.spongepowered.api.data.persistence.DataContainer;
import org.spongepowered.api.data.persistence.DataView;
import org.spongepowered.api.entity.EntityArchetype;
import org.spongepowered.api.entity.EntityType;
import org.spongepowered.api.fluid.FluidState;
import org.spongepowered.api.registry.RegistryTypes;
import org.spongepowered.api.util.transformation.Transformation;
import org.spongepowered.api.world.biome.Biome;
import org.spongepowered.api.world.schematic.Palette;
import org.spongepowered.api.world.schematic.PaletteTypes;
import org.spongepowered.api.world.schematic.Schematic;
import org.spongepowered.api.world.volume.archetype.ArchetypeVolume;
import org.spongepowered.api.world.volume.archetype.entity.EntityArchetypeEntry;
import org.spongepowered.api.world.volume.stream.StreamOptions;
import org.spongepowered.api.world.volume.stream.VolumeElement;
import org.spongepowered.api.world.volume.stream.VolumeStream;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.common.data.holder.SpongeArchetypeVolumeDataHolder;
import org.spongepowered.common.data.persistence.NBTTranslator;
import org.spongepowered.common.util.VecHelper;
import org.spongepowered.common.world.schematic.ReferentSchematicVolume;
import org.spongepowered.common.world.volume.SpongeVolumeStream;
import org.spongepowered.common.world.volume.VolumeStreamUtils;
import org.spongepowered.math.vector.Vector3i;

@Mixin(value={StructureTemplate.class})
public abstract class StructureTemplateMixin_API
implements Schematic,
SpongeArchetypeVolumeDataHolder {
    @Shadow
    @Final
    private List<StructureTemplate.Palette> palettes;
    @Shadow
    @Final
    private List<StructureTemplate.StructureEntityInfo> entityInfoList;

    @Shadow
    public abstract Vec3i shadow$getSize();

    @Override
    public Palette<org.spongepowered.api.block.BlockState, BlockType> blockPalette() {
        Palette<org.spongepowered.api.block.BlockState, BlockType> blockPallete = PaletteTypes.BLOCK_STATE_PALETTE.get().create(RegistryTypes.BLOCK_TYPE.get());
        return blockPallete;
    }

    @Override
    public Palette<Biome, Biome> biomePalette() {
        Palette<Biome, Biome> biomePalette = PaletteTypes.BIOME_PALETTE.get().create(RegistryTypes.BIOME.get());
        return biomePalette;
    }

    @Override
    public DataView metadata() {
        return DataContainer.createNew();
    }

    @Override
    public Vector3i min() {
        return Vector3i.ZERO;
    }

    @Override
    public Vector3i max() {
        return VecHelper.toVector3i(this.shadow$getSize()).sub(Vector3i.ONE);
    }

    @Override
    public boolean contains(int x, int y, int z) {
        return VecHelper.inBounds((double)x, (double)y, (double)z, this.min(), this.max());
    }

    @Override
    public boolean isAreaAvailable(int x, int y, int z) {
        return VecHelper.inBounds((double)x, (double)y, (double)z, this.min(), this.max());
    }

    @Override
    public ArchetypeVolume transform(Transformation transformation) {
        return new ReferentSchematicVolume(this, Objects.requireNonNull(transformation, "Transformation cannot be null"));
    }

    private Map<BlockPos, CompoundTag> api$buildBlockNbtMap() {
        List blockInfos = this.palettes.iterator().next().blocks();
        return blockInfos.stream().filter(info -> info.nbt() != null).collect(Collectors.toMap(StructureTemplate.StructureBlockInfo::pos, StructureTemplate.StructureBlockInfo::nbt));
    }

    @Override
    public Optional<BlockEntityArchetype> blockEntityArchetype(int x, int y, int z) {
        BlockPos pos = new BlockPos(x, y, z);
        BlockState state = this.api$buildBlockStateMap().get(pos);
        if (state.hasBlockEntity()) {
            BlockEntityType type = ((EntityBlock)state.getBlock()).newBlockEntity(pos, state).getType();
            CompoundTag nbt = this.api$buildBlockNbtMap().getOrDefault(pos, new CompoundTag());
            return Optional.of(BlockEntityArchetype.builder().state((org.spongepowered.api.block.BlockState)state).blockEntity((org.spongepowered.api.block.entity.BlockEntityType)type).blockEntityData(NBTTranslator.INSTANCE.translate(nbt)).build());
        }
        return Optional.empty();
    }

    @Override
    public Map<Vector3i, BlockEntityArchetype> blockEntityArchetypes() {
        Map<BlockPos, CompoundTag> nbtMap = this.api$buildBlockNbtMap();
        return this.api$buildBlockStateMap().entrySet().stream().filter(e -> ((BlockState)e.getValue()).hasBlockEntity()).collect(Collectors.toMap(e -> VecHelper.toVector3i((BlockPos)e.getKey()), e -> {
            BlockState state = (BlockState)e.getValue();
            BlockEntityType type = ((EntityBlock)state.getBlock()).newBlockEntity((BlockPos)e.getKey(), state).getType();
            CompoundTag nbt = nbtMap.getOrDefault(e.getKey(), new CompoundTag());
            return BlockEntityArchetype.builder().state((org.spongepowered.api.block.BlockState)state).blockEntity((org.spongepowered.api.block.entity.BlockEntityType)type).blockEntityData(NBTTranslator.INSTANCE.translate(nbt)).build();
        }));
    }

    @Override
    public VolumeStream<ArchetypeVolume, BlockEntityArchetype> blockEntityArchetypeStream(Vector3i min, Vector3i max, StreamOptions options) {
        Vector3i blockMin = this.min();
        Vector3i blockMax = this.max();
        VolumeStreamUtils.validateStreamArgs(min, max, blockMin, blockMax, options);
        Map<BlockPos, CompoundTag> nbtMap = this.api$buildBlockNbtMap();
        Stream stateStream = this.api$buildBlockStateMap().entrySet().stream().filter(e -> ((BlockState)e.getValue()).hasBlockEntity()).filter(VolumeStreamUtils.filterPositions(t -> VecHelper.toVector3i((BlockPos)t.getKey()), min, max)).map(e -> {
            BlockState state = (BlockState)e.getValue();
            BlockEntityType type = ((EntityBlock)state.getBlock()).newBlockEntity((BlockPos)e.getKey(), state).getType();
            CompoundTag nbt = nbtMap.getOrDefault(e.getKey(), new CompoundTag());
            BlockEntityArchetype value = BlockEntityArchetype.builder().state((org.spongepowered.api.block.BlockState)e.getValue()).blockEntity((org.spongepowered.api.block.entity.BlockEntityType)type).blockEntityData(NBTTranslator.INSTANCE.translate(nbt)).build();
            return VolumeElement.of(this, value, VecHelper.toVector3d((BlockPos)e.getKey()));
        });
        return new SpongeVolumeStream<ArchetypeVolume, BlockEntityArchetype>(stateStream, () -> this);
    }

    private Stream<EntityArchetypeEntry> api$buildEntityArchetypeList() {
        return this.entityInfoList.stream().map(info -> {
            Optional by = net.minecraft.world.entity.EntityType.by((CompoundTag)info.nbt);
            if (by.isPresent()) {
                DataContainer data = NBTTranslator.INSTANCE.translateFrom(info.nbt);
                EntityArchetype archetype = EntityArchetype.builder().type((EntityType)by.get()).entityData(data).build();
                return EntityArchetypeEntry.of(archetype, VecHelper.toVector3d(info.pos));
            }
            return null;
        }).filter(Objects::nonNull);
    }

    @Override
    public Collection<EntityArchetype> entityArchetypes() {
        return this.api$buildEntityArchetypeList().map(EntityArchetypeEntry::archetype).toList();
    }

    @Override
    public Collection<EntityArchetypeEntry> entityArchetypesByPosition() {
        return this.api$buildEntityArchetypeList().toList();
    }

    @Override
    public Collection<EntityArchetype> entityArchetypes(Predicate<EntityArchetype> filter) {
        return this.api$buildEntityArchetypeList().map(EntityArchetypeEntry::archetype).filter(filter).toList();
    }

    @Override
    public VolumeStream<ArchetypeVolume, EntityArchetype> entityArchetypeStream(Vector3i min, Vector3i max, StreamOptions options) {
        Vector3i blockMin = this.min();
        Vector3i blockMax = this.max();
        VolumeStreamUtils.validateStreamArgs(min, max, blockMin, blockMax, options);
        Stream stateStream = this.api$buildEntityArchetypeList().filter(VolumeStreamUtils.filterPositions(t -> t.position().toInt(), min, max)).map(e -> VolumeElement.of(this, e.archetype(), e.position()));
        return new SpongeVolumeStream<ArchetypeVolume, EntityArchetype>(stateStream, () -> this);
    }

    @Override
    public Stream<EntityArchetypeEntry> entitiesByPosition() {
        return this.api$buildEntityArchetypeList();
    }

    @Override
    public Biome biome(int x, int y, int z) {
        return null;
    }

    @Override
    public VolumeStream<ArchetypeVolume, Biome> biomeStream(Vector3i min, Vector3i max, StreamOptions options) {
        return new SpongeVolumeStream<ArchetypeVolume, Biome>(Stream.empty(), () -> this);
    }

    private Map<BlockPos, BlockState> api$buildBlockStateMap() {
        List blockInfos = this.palettes.iterator().next().blocks();
        return blockInfos.stream().collect(Collectors.toMap(StructureTemplate.StructureBlockInfo::pos, StructureTemplate.StructureBlockInfo::state));
    }

    @Override
    public org.spongepowered.api.block.BlockState block(int x, int y, int z) {
        return (org.spongepowered.api.block.BlockState)this.api$buildBlockStateMap().get(new BlockPos(x, y, z));
    }

    @Override
    public FluidState fluid(int x, int y, int z) {
        BlockState blockState = this.api$buildBlockStateMap().get(new BlockPos(x, y, z));
        if (blockState == null) {
            return null;
        }
        return (FluidState)blockState.getFluidState();
    }

    @Override
    public VolumeStream<ArchetypeVolume, org.spongepowered.api.block.BlockState> blockStateStream(Vector3i min, Vector3i max, StreamOptions options) {
        Vector3i blockMin = this.min();
        Vector3i blockMax = this.max();
        VolumeStreamUtils.validateStreamArgs(min, max, blockMin, blockMax, options);
        Stream stateStream = this.api$buildBlockStateMap().entrySet().stream().filter(VolumeStreamUtils.filterPositions(t -> VecHelper.toVector3i((BlockPos)t.getKey()), min, max)).map(e -> VolumeElement.of(this, (org.spongepowered.api.block.BlockState)e.getValue(), VecHelper.toVector3d((BlockPos)e.getKey())));
        return new SpongeVolumeStream<ArchetypeVolume, org.spongepowered.api.block.BlockState>(stateStream, () -> this);
    }

    @Override
    public int highestYAt(int x, int z) {
        return 0;
    }

    @Override
    public boolean setBlock(int x, int y, int z, org.spongepowered.api.block.BlockState block) {
        return false;
    }

    @Override
    public boolean removeBlock(int x, int y, int z) {
        return false;
    }

    @Override
    public boolean setBiome(int x, int y, int z, Biome biome) {
        return false;
    }

    @Override
    public void addBlockEntity(int x, int y, int z, BlockEntityArchetype archetype) {
    }

    @Override
    public void removeBlockEntity(int x, int y, int z) {
    }

    @Override
    public void addEntity(EntityArchetypeEntry entry) {
        Vec3 pos = VecHelper.toVanillaVector3d(entry.position());
        BlockPos blockPos = VecHelper.toBlockPos(entry.position());
        CompoundTag data = NBTTranslator.INSTANCE.translate(entry.archetype().entityData());
        StructureTemplate.StructureEntityInfo info = new StructureTemplate.StructureEntityInfo(pos, blockPos, data);
        this.entityInfoList.add(info);
    }
}

