/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.world.entity;

import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.stats.Stats;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.tags.EntityTypeTags;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.WalkAnimationState;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import org.apache.logging.log4j.Level;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.common.SpongeCommon;
import org.spongepowered.common.bridge.world.entity.EntityTypeBridge;
import org.spongepowered.common.bridge.world.entity.LivingEntityBridge;
import org.spongepowered.common.bridge.world.entity.PlatformLivingEntityBridge;
import org.spongepowered.common.event.cause.entity.damage.SpongeDamageSources;
import org.spongepowered.common.mixin.core.world.entity.EntityMixin;
import org.spongepowered.common.util.PrettyPrinter;

@Mixin(value={LivingEntity.class}, priority=900)
public abstract class LivingEntityMixin_Attack_impl
extends EntityMixin
implements LivingEntityBridge,
PlatformLivingEntityBridge {
    @Shadow
    private DamageSource lastDamageSource;
    @Shadow
    protected float lastHurt;
    @Shadow
    protected int noActionTime;
    @Shadow
    public int hurtDuration;
    @Shadow
    public int hurtTime;
    @Shadow
    protected int lastHurtByPlayerTime;
    @Shadow
    @javax.annotation.Nullable
    protected Player lastHurtByPlayer;
    @Shadow
    private long lastDamageStamp;
    @Shadow
    @Final
    public WalkAnimationState walkAnimation;

    @Shadow
    public abstract boolean shadow$hasEffect(MobEffect var1);

    @Shadow
    public abstract boolean shadow$isSleeping();

    @Shadow
    public abstract void shadow$stopSleeping();

    @Shadow
    public abstract boolean shadow$isDamageSourceBlocked(DamageSource var1);

    @Shadow
    protected abstract void shadow$actuallyHurt(DamageSource var1, float var2);

    @Shadow
    public abstract void shadow$setLastHurtByMob(@Nullable LivingEntity var1);

    @Shadow
    public abstract void shadow$knockback(double var1, double var3, double var5);

    @Shadow
    protected abstract boolean shadow$checkTotemDeathProtection(DamageSource var1);

    @Shadow
    @javax.annotation.Nullable
    protected abstract SoundEvent shadow$getDeathSound();

    @Shadow
    protected abstract float shadow$getSoundVolume();

    @Shadow
    protected abstract float shadow$getVoicePitch();

    @Shadow
    public abstract void shadow$die(DamageSource var1);

    @Shadow
    protected abstract void shadow$playHurtSound(DamageSource var1);

    @Shadow
    public abstract boolean shadow$isDeadOrDying();

    @Shadow
    public abstract ItemStack shadow$getItemBySlot(EquipmentSlot var1);

    @Shadow
    protected abstract void shadow$hurtHelmet(DamageSource var1, float var2);

    @Shadow
    public abstract void shadow$indicateDamage(double var1, double var3);

    @Overwrite
    public boolean hurt(DamageSource source, float amount) {
        ServerPlayer player;
        LivingEntity livingEntity;
        boolean notBlocked;
        Entity entity;
        this.lastDamageSource = source;
        if (source == null) {
            new PrettyPrinter(60).centre().add("Null DamageSource").hr().addWrapped("Sponge has found a null damage source! This should NEVER happen as the DamageSource is used for all sorts of calculations. Usually this can be considered developer error. Please report the following stacktrace to the most appropriate mod/plugin available.", new Object[0]).add().add(new IllegalArgumentException("Null DamageSource")).log(SpongeCommon.logger(), Level.WARN);
            return false;
        }
        if (!this.bridge$onLivingAttack((LivingEntity)this, source, amount)) {
            return false;
        }
        if (this.shadow$isInvulnerableTo(source)) {
            return false;
        }
        if (this.shadow$level().isClientSide) {
            return false;
        }
        if (this.shadow$isDeadOrDying() && source != SpongeDamageSources.IGNORED) {
            return false;
        }
        if (source.is(DamageTypeTags.IS_FIRE) && this.shadow$hasEffect(MobEffects.FIRE_RESISTANCE)) {
            return false;
        }
        if (this.shadow$isSleeping() && !this.shadow$level().isClientSide) {
            this.shadow$stopSleeping();
        }
        this.noActionTime = 0;
        float f2 = amount;
        float blockedAmount = 0.0f;
        boolean isBlocked = false;
        if (amount > 0.0f && this.shadow$isDamageSourceBlocked(source)) {
            blockedAmount = amount;
            isBlocked = true;
        }
        if (source.is(DamageTypeTags.IS_FREEZING) && this.shadow$getType().is(EntityTypeTags.FREEZE_HURTS_EXTRA_TYPES)) {
            amount *= 5.0f;
        }
        this.walkAnimation.setSpeed(1.5f);
        boolean isNotInvulnerable = true;
        if ((float)this.invulnerableTime > 10.0f && !source.is(DamageTypeTags.BYPASSES_COOLDOWN)) {
            if (amount <= this.lastHurt) {
                return false;
            }
            if (((EntityTypeBridge)this.shadow$getType()).bridge$overridesDamageEntity()) {
                this.shadow$actuallyHurt(source, amount - this.lastHurt);
            } else if (!this.bridge$damageEntity(source, amount - this.lastHurt)) {
                return false;
            }
            this.lastHurt = amount;
            isNotInvulnerable = false;
        } else {
            if (((EntityTypeBridge)this.shadow$getType()).bridge$overridesDamageEntity()) {
                this.shadow$actuallyHurt(source, amount);
            } else if (!this.bridge$damageEntity(source, amount)) {
                return false;
            }
            this.lastHurt = amount;
            this.invulnerableTime = 20;
            this.hurtTime = this.hurtDuration = 10;
        }
        if (source.is(DamageTypeTags.DAMAGES_HELMET) && !this.shadow$getItemBySlot(EquipmentSlot.HEAD).isEmpty()) {
            this.shadow$hurtHelmet(source, amount);
            amount *= 0.75f;
        }
        if ((entity = source.getEntity()) != null) {
            TamableAnimal animal;
            if (entity instanceof LivingEntity) {
                LivingEntity livingEntity2 = (LivingEntity)entity;
                if (!source.is(DamageTypeTags.NO_ANGER)) {
                    this.shadow$setLastHurtByMob(livingEntity2);
                }
            }
            if (entity instanceof Player) {
                Player player2 = (Player)entity;
                this.lastHurtByPlayerTime = 100;
                this.lastHurtByPlayer = player2;
            } else if (entity instanceof TamableAnimal && (animal = (TamableAnimal)entity).isTame()) {
                Player player3;
                this.lastHurtByPlayerTime = 100;
                LivingEntity owner = animal.getOwner();
                this.lastHurtByPlayer = owner instanceof Player ? (player3 = (Player)owner) : null;
            }
        }
        if (isNotInvulnerable) {
            if (isBlocked) {
                this.shadow$level().broadcastEntityEvent((Entity)((LivingEntity)this), (byte)29);
            } else {
                this.shadow$level().broadcastDamageEvent((Entity)((LivingEntity)this), source);
            }
            if (!source.is(DamageTypeTags.NO_IMPACT) && !isBlocked) {
                this.shadow$markHurt();
            }
            if (entity != null && !source.is(DamageTypeTags.IS_EXPLOSION)) {
                double xDir = entity.getX() - this.shadow$getX();
                double zDir = entity.getZ() - this.shadow$getZ();
                while (xDir * xDir + zDir * zDir < 1.0E-4) {
                    xDir = (Math.random() - Math.random()) * 0.01;
                    zDir = (Math.random() - Math.random()) * 0.01;
                }
                this.shadow$knockback(0.4f, xDir, zDir);
                if (!isBlocked) {
                    this.shadow$indicateDamage(xDir, zDir);
                }
            }
        }
        if (this.shadow$isDeadOrDying()) {
            if (!this.shadow$checkTotemDeathProtection(source)) {
                SoundEvent soundevent = this.shadow$getDeathSound();
                if (isNotInvulnerable && soundevent != null && this.bridge$vanishState().createsSounds()) {
                    this.shadow$playSound(soundevent, this.shadow$getSoundVolume(), this.shadow$getVoicePitch());
                }
                this.shadow$die(source);
            }
        } else if (isNotInvulnerable && this.bridge$vanishState().createsSounds()) {
            this.shadow$playHurtSound(source);
        }
        boolean bl = notBlocked = !isBlocked;
        if (notBlocked) {
            this.lastDamageSource = source;
            this.lastDamageStamp = this.shadow$level().getGameTime();
        }
        if ((livingEntity = (LivingEntity)this) instanceof ServerPlayer) {
            player = (ServerPlayer)livingEntity;
            CriteriaTriggers.ENTITY_HURT_PLAYER.trigger(player, source, f2, amount, isBlocked);
            if (blockedAmount > 0.0f && blockedAmount < 3.4028235E37f) {
                player.awardStat(Stats.DAMAGE_BLOCKED_BY_SHIELD, Math.round(blockedAmount * 10.0f));
            }
        }
        if (entity instanceof ServerPlayer) {
            player = (ServerPlayer)entity;
            CriteriaTriggers.PLAYER_HURT_ENTITY.trigger(player, (Entity)this, source, f2, amount, isBlocked);
        }
        return notBlocked;
    }
}

