/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.world.entity.animal;

import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.animal.Animal;
import org.spongepowered.api.entity.living.Ageable;
import org.spongepowered.api.event.CauseStackManager;
import org.spongepowered.api.event.SpongeEventFactory;
import org.spongepowered.api.event.entity.BreedingEvent;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;
import org.spongepowered.common.SpongeCommon;
import org.spongepowered.common.event.ShouldFire;
import org.spongepowered.common.event.tracking.PhaseTracker;
import org.spongepowered.common.mixin.core.world.entity.AgableMobMixin;

@Mixin(value={Animal.class})
public abstract class AnimalMixin
extends AgableMobMixin {
    @Inject(method={"finalizeSpawnChildFromBreeding"}, locals=LocalCapture.CAPTURE_FAILEXCEPTION, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/animal/Animal;getLoveCause()Lnet/minecraft/server/level/ServerPlayer;", ordinal=0)}, cancellable=true)
    private void impl$cancelSpawnResultIfMarked(ServerLevel level, Animal partner, AgeableMob offspring, CallbackInfo ci) {
        if (ShouldFire.BREEDING_EVENT_BREED) {
            try (CauseStackManager.StackFrame frame = PhaseTracker.getCauseStackManager().pushCauseFrame();){
                frame.pushCause(this);
                frame.pushCause(partner);
                BreedingEvent.Breed event = SpongeEventFactory.createBreedingEventBreed(PhaseTracker.getCauseStackManager().currentCause(), (Ageable)offspring);
                if (SpongeCommon.post(event) || !this.shadow$level().addFreshEntity((Entity)offspring)) {
                    ci.cancel();
                }
            }
        }
    }
}

