/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.tracker.server.level;

import net.minecraft.server.level.ChunkHolder;
import net.minecraft.server.level.ChunkMap;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.LevelChunk;
import org.apache.logging.log4j.Level;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.spongepowered.api.world.server.ServerWorld;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.Slice;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.common.SpongeCommon;
import org.spongepowered.common.applaunch.config.core.SpongeConfigs;
import org.spongepowered.common.bridge.world.level.LevelBridge;
import org.spongepowered.common.event.tracking.PhasePrinter;
import org.spongepowered.common.event.tracking.PhaseTracker;
import org.spongepowered.common.event.tracking.phase.generation.ChunkLoadContext;
import org.spongepowered.common.event.tracking.phase.generation.GenerationPhase;
import org.spongepowered.common.util.PrettyPrinter;

@Mixin(value={ChunkMap.class})
public abstract class ChunkMapMixin_Tracker {
    @Shadow
    @Final
    ServerLevel level;

    @Redirect(method={"addEntity(Lnet/minecraft/world/entity/Entity;)V"}, at=@At(value="NEW", args={"class=java/lang/IllegalStateException"}, remap=false))
    private IllegalStateException tracker$reportEntityAlreadyTrackedWithWorld(String string, Entity entityIn) {
        IllegalStateException exception = new IllegalStateException(String.format("Entity %s is already tracked for world: %s", entityIn, ((ServerWorld)this.level).key()));
        if (SpongeConfigs.getCommon().get().phaseTracker.verboseErrors) {
            PhasePrinter.printMessageWithCaughtException(PhaseTracker.getInstance(), "Exception tracking entity", "An entity that was already tracked was added to the tracker!", exception);
        }
        return exception;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Redirect(method={"lambda$prepareTickingChunk$41"}, at=@At(value="INVOKE", target="Lnet/minecraft/server/level/ServerLevel;startTickingChunk(Lnet/minecraft/world/level/chunk/LevelChunk;)V"))
    private void tracker$wrapUnpackTicks(ServerLevel level, LevelChunk chunk) {
        if (!PhaseTracker.SERVER.onSidedThread()) {
            new PrettyPrinter(60).add("Illegal Async Chunk Unpacking").centre().hr().addWrapped("Someone is attempting to unpack chunk scheduled updates while off the main thread, this isgenerally unsupported and Sponge would appreciate a report about this. Please attach the generated classes output as a zip file after enabling -Dmixin.debug.export=true and request triage support on discord. Do NOT report as an issue on GitHub.", new Object[0]).add().add(" %s : %s", "Chunk Pos", chunk.getPos().toString()).add().add(new Exception("Async Chunk Scheduling Detected")).log(SpongeCommon.logger(), Level.ERROR);
            return;
        }
        if (PhaseTracker.getInstance().getCurrentState() == GenerationPhase.State.CHUNK_LOADING) {
            return;
        }
        try (@NonNull ChunkLoadContext ctx = ((ChunkLoadContext)((ChunkLoadContext)GenerationPhase.State.CHUNK_LOADING.createPhaseContext(PhaseTracker.getInstance()).source(chunk)).world(level)).chunk(chunk);){
            ctx.buildAndSwitch();
            chunk.unpackTicks(level.getLevelData().getGameTime());
        }
    }

    @Redirect(method={"lambda$protoChunkToFullChunk$34"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/level/chunk/LevelChunk;runPostLoad()V"), slice=@Slice(from=@At(value="INVOKE", target="Lnet/minecraft/world/level/chunk/LevelChunk;setFullStatus(Ljava/util/function/Supplier;)V"), to=@At(value="INVOKE", target="Lnet/minecraft/world/level/chunk/LevelChunk;registerAllBlockEntitiesAfterLevelLoad()V")))
    private void tracker$startLoad(LevelChunk chunk) {
        chunk.runPostLoad();
        boolean isFake = ((LevelBridge)chunk.getLevel()).bridge$isFake();
        if (isFake) {
            return;
        }
        if (!PhaseTracker.SERVER.onSidedThread()) {
            new PrettyPrinter(60).add("Illegal Async Chunk Load").centre().hr().addWrapped("Sponge relies on knowing when chunks are being loaded as chunks add entities to the parented world for management. These operations are generally not threadsafe and shouldn't be considered a \"Sponge bug \". Adding/removing entities from another thread to the world is never ok.", new Object[0]).add().add(" %s : %s", "Chunk Pos", chunk.getPos().toString()).add().add(new Exception("Async Chunk Load Detected")).log(SpongeCommon.logger(), Level.ERROR);
            return;
        }
        if (PhaseTracker.getInstance().getCurrentState() == GenerationPhase.State.CHUNK_REGENERATING_LOAD_EXISTING) {
            return;
        }
        ((ChunkLoadContext)((ChunkLoadContext)GenerationPhase.State.CHUNK_LOADING.createPhaseContext(PhaseTracker.getInstance()).source(chunk)).world((ServerLevel)chunk.getLevel())).chunk(chunk).buildAndSwitch();
    }

    @Inject(method={"lambda$protoChunkToFullChunk$34"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/level/chunk/LevelChunk;registerAllBlockEntitiesAfterLevelLoad()V", shift=At.Shift.BY, by=2)}, slice={@Slice(from=@At(value="INVOKE", target="Lnet/minecraft/world/level/chunk/LevelChunk;runPostLoad()V"))}, require=1)
    private void tracker$endLoad(ChunkHolder chunkHolder, ChunkAccess chunk, CallbackInfoReturnable<ChunkAccess> cir) {
        if (!((LevelBridge)this.level).bridge$isFake() && PhaseTracker.SERVER.onSidedThread()) {
            if (PhaseTracker.getInstance().getCurrentState() == GenerationPhase.State.CHUNK_REGENERATING_LOAD_EXISTING) {
                return;
            }
            PhaseTracker.getInstance().getPhaseContext().close();
        }
    }
}

