/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.network.status;

import com.google.common.base.Preconditions;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.OptionalInt;
import javax.imageio.ImageIO;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import net.kyori.adventure.text.serializer.plain.PlainTextComponentSerializer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.status.ServerStatus;
import net.minecraft.server.MinecraftServer;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.MinecraftVersion;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.event.Cause;
import org.spongepowered.api.event.EventContext;
import org.spongepowered.api.event.SpongeEventFactory;
import org.spongepowered.api.event.server.ClientPingServerEvent;
import org.spongepowered.api.network.status.Favicon;
import org.spongepowered.api.network.status.StatusClient;
import org.spongepowered.api.profile.GameProfile;
import org.spongepowered.common.SpongeCommon;
import org.spongepowered.common.adventure.SpongeAdventure;
import org.spongepowered.common.network.status.SpongeLegacyStatusClient;
import org.spongepowered.common.profile.SpongeGameProfile;
import org.spongepowered.common.util.NetworkUtil;

public final class SpongeStatusResponse
implements ClientPingServerEvent.Response {
    private Component description;
    private SpongeStatusPlayers players;
    private boolean hiddenPlayers;
    private SpongeStatusVersion version;
    private ServerStatus.Favicon favicon;
    private final boolean enforcesSecureChat;

    private SpongeStatusResponse(ServerStatus status) {
        this.description = status.description();
        this.players = new SpongeStatusPlayers(status.players().orElse(null));
        this.hiddenPlayers = false;
        this.version = new SpongeStatusVersion(status.version().orElse(null));
        this.favicon = status.favicon().orElse(null);
        this.enforcesSecureChat = status.enforcesSecureChat();
    }

    @Override
    public void setDescription(net.kyori.adventure.text.Component description) {
        this.description = SpongeAdventure.asVanilla((net.kyori.adventure.text.Component)Preconditions.checkNotNull((Object)description, (Object)"description"));
    }

    @Override
    public net.kyori.adventure.text.Component description() {
        return SpongeAdventure.asAdventure(this.description);
    }

    @Override
    public Optional<ClientPingServerEvent.Response.Players> players() {
        if (this.hiddenPlayers) {
            return Optional.empty();
        }
        return Optional.ofNullable(this.players);
    }

    @Override
    public void setHidePlayers(boolean hide) {
        this.hiddenPlayers = hide;
    }

    @Override
    public void setFavicon(@Nullable Favicon favicon) {
        if (favicon == null) {
            this.favicon = null;
            return;
        }
        ByteArrayOutputStream bytes = new ByteArrayOutputStream();
        try {
            ImageIO.write((RenderedImage)favicon.image(), "PNG", bytes);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.favicon = new ServerStatus.Favicon(bytes.toByteArray());
    }

    @Override
    public ClientPingServerEvent.Response.Version version() {
        return this.version;
    }

    @Override
    public Optional<Favicon> favicon() {
        return Optional.ofNullable((Favicon)this.favicon);
    }

    private ServerStatus toVanilla() {
        return new ServerStatus(this.description, Optional.ofNullable(this.hiddenPlayers || this.players == null ? null : this.players.toVanilla()), Optional.of(this.version.toVanilla()), Optional.ofNullable(this.favicon), this.enforcesSecureChat);
    }

    public String motd() {
        return SpongeStatusResponse.getFirstLine(LegacyComponentSerializer.legacySection().serialize(SpongeAdventure.asAdventure(this.description)));
    }

    public String unformattedMotd() {
        return SpongeStatusResponse.getFirstLine(PlainTextComponentSerializer.plainText().serialize(SpongeAdventure.asAdventure(this.description)));
    }

    public int onlinePlayers() {
        return !this.hiddenPlayers && this.players != null ? this.players.online : 0;
    }

    public int maxPlayers() {
        return !this.hiddenPlayers && this.players != null ? this.players.max : -1;
    }

    public static @Nullable ServerStatus post(ServerStatus status, StatusClient client) {
        SpongeStatusResponse response = SpongeStatusResponse.call(status, client);
        return response != null ? response.toVanilla() : null;
    }

    public static @Nullable SpongeStatusResponse postLegacy(MinecraftServer server, InetSocketAddress address, MinecraftVersion version, InetSocketAddress virtualHost) {
        return SpongeStatusResponse.call(server.getStatus(), new SpongeLegacyStatusClient(address, version, virtualHost));
    }

    private static @Nullable SpongeStatusResponse call(ServerStatus response, StatusClient client) {
        SpongeStatusResponse mutableResponse = new SpongeStatusResponse(response);
        if (!SpongeCommon.post(SpongeEventFactory.createClientPingServerEvent(Cause.of(EventContext.empty(), Sponge.server()), client, mutableResponse))) {
            return mutableResponse;
        }
        return null;
    }

    private static String getFirstLine(String s) {
        return NetworkUtil.substringBefore(s, '\n');
    }

    public static final class SpongeStatusPlayers
    implements ClientPingServerEvent.Response.Players {
        private int max;
        private int online;
        private final List<GameProfile> profiles = new ArrayList<GameProfile>();

        public SpongeStatusPlayers(ServerStatus.Players players) {
            if (players == null) {
                this.max = -1;
                this.online = 0;
            } else {
                this.max = players.max();
                this.online = players.online();
                players.sample().forEach(profile -> this.profiles.add(SpongeGameProfile.of(profile)));
            }
        }

        @Override
        public int max() {
            return this.max;
        }

        @Override
        public int online() {
            return this.online;
        }

        @Override
        public List<GameProfile> profiles() {
            return this.profiles;
        }

        @Override
        public void setOnline(int online) {
            this.online = online;
        }

        @Override
        public void setMax(int max) {
            this.max = max;
        }

        public ServerStatus.Players toVanilla() {
            return new ServerStatus.Players(this.max, this.online, this.profiles.stream().map(SpongeGameProfile::toMcProfileNonNull).toList());
        }
    }

    public static final class SpongeStatusVersion
    implements ClientPingServerEvent.Response.Version {
        private String name;
        private int protocol;

        public SpongeStatusVersion(ServerStatus.Version version) {
            if (version != null) {
                this.name = version.name();
                this.protocol = version.protocol();
            } else {
                this.name = "";
                this.protocol = 0;
            }
        }

        @Override
        public String name() {
            return this.name;
        }

        @Override
        public void setName(String name) {
            this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"name");
        }

        @Override
        public boolean isLegacy() {
            return false;
        }

        @Override
        public int protocolVersion() {
            return this.protocol;
        }

        @Override
        public void setProtocolVersion(int protocolVersion) {
            this.protocol = protocolVersion;
        }

        @Override
        public OptionalInt dataVersion() {
            return OptionalInt.empty();
        }

        public ServerStatus.Version toVanilla() {
            return new ServerStatus.Version(this.name, this.protocol);
        }
    }
}

