/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.service.server.ban;

import java.io.File;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Date;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import net.minecraft.server.players.IpBanList;
import net.minecraft.server.players.IpBanListEntry;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.service.ban.Ban;
import org.spongepowered.common.util.BanUtil;
import org.spongepowered.common.util.NetworkUtil;

public final class SpongeIPBanList
extends IpBanList {
    public SpongeIPBanList(File file) {
        super(file);
    }

    protected boolean contains(String entry) {
        if (entry.equals("local")) {
            return false;
        }
        try {
            return Sponge.server().serviceProvider().banService().find(InetAddress.getByName(entry)).join().isPresent();
        }
        catch (UnknownHostException e) {
            throw new IllegalArgumentException("Error parsing Ban IP address!", e);
        }
    }

    public @Nullable IpBanListEntry get(String obj) {
        if (obj.equals("local")) {
            return null;
        }
        try {
            return Sponge.server().serviceProvider().banService().find(InetAddress.getByName(obj)).join().map(ban -> {
                if (ban instanceof IpBanListEntry) {
                    return (IpBanListEntry)ban;
                }
                LegacyComponentSerializer lcs = LegacyComponentSerializer.legacySection();
                return new IpBanListEntry(BanUtil.addressToBanCompatibleString(ban.address()), Date.from(ban.creationDate()), (String)ban.banSource().map(arg_0 -> ((LegacyComponentSerializer)lcs).serialize(arg_0)).orElse(null), (Date)ban.expirationDate().map(Date::from).orElse(null), (String)ban.reason().map(arg_0 -> ((LegacyComponentSerializer)lcs).serialize(arg_0)).orElse(null));
            }).orElse(null);
        }
        catch (UnknownHostException e) {
            throw new IllegalArgumentException("Error parsing Ban IP address!", e);
        }
    }

    public void remove(String entry) {
        if (entry.equals("local")) {
            return;
        }
        try {
            Sponge.server().serviceProvider().banService().pardon(InetAddress.getByName(entry)).join();
        }
        catch (UnknownHostException e) {
            throw new IllegalArgumentException("Error parsing Ban IP address!", e);
        }
    }

    public String[] getUserList() {
        ArrayList<String> ips = new ArrayList<String>();
        for (Ban.IP ban : Sponge.server().serviceProvider().banService().ipBans().join()) {
            ips.add(this.getIpFromAddress(new InetSocketAddress(ban.address(), 0)));
        }
        return ips.toArray(new String[0]);
    }

    public void add(IpBanListEntry entry) {
        Sponge.server().serviceProvider().banService().add((Ban)entry).join();
    }

    public boolean isEmpty() {
        return Sponge.server().serviceProvider().banService().ipBans().join().isEmpty();
    }

    public String getIpFromAddress(SocketAddress address) {
        return NetworkUtil.getHostString(address);
    }
}

