/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.util;

import java.io.IOException;
import java.io.InputStream;
import java.util.StringJoiner;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;
import org.spongepowered.common.SpongeCommon;
import org.spongepowered.common.launch.Launch;

public final class ReflectionUtil {
    public static final Marker REFLECTION_SCANNING = MarkerManager.getMarker((String)"REFLECTION_SCANNING");
    private static final Class<?>[] NEIGHBOR_CHANGED_METHOD_ARGS = new Class[]{BlockState.class, Level.class, BlockPos.class, Block.class, BlockPos.class, Boolean.TYPE};
    private static final Class<?>[] ENTITY_INSIDE_METHOD_ARGS = new Class[]{BlockState.class, Level.class, BlockPos.class, Entity.class};
    private static final Class<?>[] STEP_ON_METHOD_ARGS = new Class[]{Level.class, BlockPos.class, BlockState.class, Entity.class};
    private static final Class<?>[] PLAYER_TOUCH_METHOD_ARGS = new Class[]{Player.class};

    public static boolean isNeighborChangedDeclared(Class<?> targetClass) {
        return ReflectionUtil.doesMethodExist(targetClass, Block.class, "neighborChanged", NEIGHBOR_CHANGED_METHOD_ARGS, Void.TYPE);
    }

    public static boolean isEntityInsideDeclared(Class<?> targetClass) {
        return ReflectionUtil.doesMethodExist(targetClass, BlockBehaviour.class, "entityInside", ENTITY_INSIDE_METHOD_ARGS, Void.TYPE);
    }

    public static boolean isStepOnDeclared(Class<?> targetClass) {
        return ReflectionUtil.doesMethodExist(targetClass, Block.class, "stepOn", STEP_ON_METHOD_ARGS, Void.TYPE);
    }

    public static boolean isPlayerTouchDeclared(Class<?> targetClass) {
        return ReflectionUtil.doesMethodExist(targetClass, Entity.class, "playerTouch", PLAYER_TOUCH_METHOD_ARGS, Void.TYPE);
    }

    public static boolean doesMethodExist(Class<?> targetClass, Class<?> ignoredClass, String methodName, Class<?>[] methodParameters, Class<?> returnType) {
        String targetMethodForEnvironment = ((Launch)Launch.instance()).mappingManager().toRuntimeMethodName(targetClass, methodName, methodParameters);
        try {
            for (Class<?> clazz = targetClass; clazz != null; clazz = clazz.getSuperclass()) {
                if (clazz == Object.class || clazz == ignoredClass || clazz.getClassLoader() == null) {
                    return false;
                }
                InputStream targetClassStream = clazz.getClassLoader().getResourceAsStream(clazz.getName().replace('.', '/') + ".class");
                if (targetClassStream == null) {
                    return true;
                }
                ClassReader reader = new ClassReader(targetClassStream);
                MethodCheckerClassVisitor visitor = new MethodCheckerClassVisitor(targetMethodForEnvironment, methodParameters, returnType);
                reader.accept(visitor, 7);
                boolean declared = visitor.wasMethodDeclared();
                if (!declared) continue;
                return true;
            }
            return false;
        }
        catch (NoClassDefFoundError e) {
            SpongeCommon.logger().fatal(REFLECTION_SCANNING, String.format("Failed to load class in %s while scanning desired method %s under environment method name %s", targetClass, methodName, targetMethodForEnvironment), (Throwable)e);
            return true;
        }
        catch (IOException e) {
            SpongeCommon.logger().fatal(REFLECTION_SCANNING, String.format("Class file exception while trying to load %s looking for method %s (%s in targeted environment)", targetClass, methodName, targetMethodForEnvironment), (Throwable)e);
            return true;
        }
    }

    private ReflectionUtil() {
    }

    static class MethodCheckerClassVisitor
    extends ClassVisitor {
        private final String targetMethod;
        private final String methodDescriptor;
        private boolean declared = false;

        public MethodCheckerClassVisitor(String targetMethodForEnvironment, Class<?>[] methodParameters, Class<?> returnType) {
            super(524288);
            this.targetMethod = targetMethodForEnvironment;
            StringJoiner joiner = new StringJoiner("", "(", ")");
            for (Class<?> clazz : methodParameters) {
                joiner.add(Type.getType(clazz).getDescriptor());
            }
            this.methodDescriptor = joiner + Type.getType(returnType).getDescriptor();
        }

        @Override
        public MethodVisitor visitMethod(int access, String name, String descriptor, String signature, String[] exceptions) {
            if (this.targetMethod.equals(name) && this.methodDescriptor.equals(descriptor)) {
                this.declared = true;
            }
            return super.visitMethod(access, name, descriptor, signature, exceptions);
        }

        public boolean wasMethodDeclared() {
            return this.declared;
        }
    }
}

