/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.world;

import com.google.common.base.MoreObjects;
import org.spongepowered.api.world.BlockChangeFlag;
import org.spongepowered.common.event.tracking.BlockChangeFlagManager;

public final class SpongeBlockChangeFlag
implements BlockChangeFlag {
    private final boolean updateNeighbors;
    private final boolean notifyClients;
    private final boolean performBlockPhysics;
    private final boolean updateNeighborShapes;
    private final boolean ignoreRender;
    private final boolean forceReRender;
    private final boolean blockMoving;
    private final boolean lighting;
    private final boolean pathfindingUpdates;
    private final boolean neighborDrops;
    private final int rawFlag;

    public SpongeBlockChangeFlag(int flag) {
        this.updateNeighbors = (flag & 1) != 0;
        this.notifyClients = (flag & 2) != 0;
        this.ignoreRender = (flag & 4) != 0;
        this.forceReRender = (flag & 8) != 0;
        this.updateNeighborShapes = (flag & 0x10) == 0;
        this.neighborDrops = (flag & 0x20) == 0;
        this.blockMoving = (flag & 0x40) != 0;
        this.lighting = (flag & 0x80) == 0;
        this.performBlockPhysics = (flag & 0x100) == 0;
        this.pathfindingUpdates = (flag & 0x200) == 0;
        this.rawFlag = flag;
    }

    @Override
    public boolean updateNeighbors() {
        return this.updateNeighbors;
    }

    @Override
    public boolean notifyClients() {
        return this.notifyClients;
    }

    @Override
    public boolean performBlockPhysics() {
        return this.performBlockPhysics;
    }

    @Override
    public boolean updateNeighboringShapes() {
        return this.updateNeighborShapes;
    }

    @Override
    public boolean updateLighting() {
        return this.lighting;
    }

    @Override
    public boolean notifyPathfinding() {
        return this.pathfindingUpdates;
    }

    @Override
    public boolean ignoreRender() {
        return this.ignoreRender;
    }

    @Override
    public boolean forceClientRerender() {
        return this.forceReRender;
    }

    @Override
    public boolean movingBlocks() {
        return this.blockMoving;
    }

    @Override
    public boolean neighborDropsAllowed() {
        return this.neighborDrops;
    }

    @Override
    public SpongeBlockChangeFlag withUpdateNeighbors(boolean updateNeighbors) {
        if (this.updateNeighbors == updateNeighbors) {
            return this;
        }
        int maskedFlag = (updateNeighbors ? 1 : 0) | (this.notifyClients ? 2 : 0) | (this.ignoreRender ? 4 : 0) | (this.forceReRender ? 8 : 0) | (this.updateNeighborShapes ? 0 : 16) | (this.neighborDrops ? 0 : 32) | (this.blockMoving ? 64 : 0) | (this.performBlockPhysics ? 0 : 256) | (this.lighting ? 0 : 128) | (this.pathfindingUpdates ? 0 : 512);
        return BlockChangeFlagManager.fromNativeInt(maskedFlag);
    }

    @Override
    public SpongeBlockChangeFlag withNotifyClients(boolean notifyClients) {
        if (this.notifyClients == notifyClients) {
            return this;
        }
        int maskedFlag = (this.updateNeighbors ? 1 : 0) | (notifyClients ? 2 : 0) | (this.ignoreRender ? 4 : 0) | (this.forceReRender ? 8 : 0) | (this.updateNeighborShapes ? 0 : 16) | (this.neighborDrops ? 0 : 32) | (this.blockMoving ? 64 : 0) | (this.performBlockPhysics ? 0 : 256) | (this.lighting ? 0 : 128) | (this.pathfindingUpdates ? 0 : 512);
        return BlockChangeFlagManager.fromNativeInt(maskedFlag);
    }

    @Override
    public SpongeBlockChangeFlag withPhysics(boolean performBlockPhysics) {
        if (this.performBlockPhysics == performBlockPhysics) {
            return this;
        }
        int maskedFlag = (this.updateNeighbors ? 1 : 0) | (this.notifyClients ? 2 : 0) | (this.ignoreRender ? 4 : 0) | (this.forceReRender ? 8 : 0) | (this.updateNeighborShapes ? 0 : 16) | (this.neighborDrops ? 0 : 32) | (this.blockMoving ? 64 : 0) | (performBlockPhysics ? 0 : 256) | (this.lighting ? 0 : 128) | (this.pathfindingUpdates ? 0 : 512);
        return BlockChangeFlagManager.fromNativeInt(maskedFlag);
    }

    @Override
    public SpongeBlockChangeFlag withNotifyObservers(boolean notifyObservers) {
        if (this.updateNeighborShapes == notifyObservers) {
            return this;
        }
        int maskedFlag = (this.updateNeighbors ? 1 : 0) | (this.notifyClients ? 2 : 0) | (this.ignoreRender ? 4 : 0) | (this.forceReRender ? 8 : 0) | (notifyObservers ? 0 : 16) | (this.neighborDrops ? 0 : 32) | (this.blockMoving ? 64 : 0) | (this.performBlockPhysics ? 0 : 256) | (this.lighting ? 0 : 128) | (this.pathfindingUpdates ? 0 : 512);
        return BlockChangeFlagManager.fromNativeInt(maskedFlag);
    }

    @Override
    public SpongeBlockChangeFlag withLightingUpdates(boolean lighting) {
        if (this.lighting == lighting) {
            return this;
        }
        int maskedFlag = (this.updateNeighbors ? 1 : 0) | (this.notifyClients ? 2 : 0) | (this.ignoreRender ? 4 : 0) | (this.forceReRender ? 8 : 0) | (this.updateNeighborShapes ? 0 : 16) | (this.neighborDrops ? 0 : 32) | (this.blockMoving ? 64 : 0) | (this.performBlockPhysics ? 0 : 256) | (lighting ? 0 : 128) | (this.pathfindingUpdates ? 0 : 512);
        return BlockChangeFlagManager.fromNativeInt(maskedFlag);
    }

    @Override
    public SpongeBlockChangeFlag withPathfindingUpdates(boolean pathfindingUpdates) {
        if (this.pathfindingUpdates == pathfindingUpdates) {
            return this;
        }
        int maskedFlag = (this.updateNeighbors ? 1 : 0) | (this.notifyClients ? 2 : 0) | (this.ignoreRender ? 4 : 0) | (this.forceReRender ? 8 : 0) | (this.updateNeighborShapes ? 0 : 16) | (this.neighborDrops ? 0 : 32) | (this.blockMoving ? 64 : 0) | (this.performBlockPhysics ? 0 : 256) | (this.lighting ? 0 : 128) | (pathfindingUpdates ? 0 : 512);
        return BlockChangeFlagManager.fromNativeInt(maskedFlag);
    }

    @Override
    public SpongeBlockChangeFlag inverse() {
        int maskedFlag = (this.updateNeighbors ? 0 : 1) | (this.notifyClients ? 0 : 2) | (this.ignoreRender ? 0 : 4) | (this.forceReRender ? 0 : 8) | (this.updateNeighborShapes ? 16 : 0) | (this.neighborDrops ? 32 : 0) | (this.blockMoving ? 0 : 64) | (this.performBlockPhysics ? 256 : 0) | (this.lighting ? 128 : 0) | (this.pathfindingUpdates ? 512 : 0);
        return BlockChangeFlagManager.fromNativeInt(maskedFlag);
    }

    @Override
    public SpongeBlockChangeFlag andFlag(BlockChangeFlag flag) {
        SpongeBlockChangeFlag o = (SpongeBlockChangeFlag)flag;
        int maskedFlag = (this.updateNeighbors || o.updateNeighbors ? 1 : 0) | (this.notifyClients || o.notifyClients ? 2 : 0) | (this.ignoreRender || o.ignoreRender ? 4 : 0) | (this.forceReRender || o.forceReRender ? 8 : 0) | (this.updateNeighborShapes || o.updateNeighborShapes ? 0 : 16) | (this.neighborDrops || o.neighborDrops ? 0 : 32) | (this.blockMoving || o.blockMoving ? 64 : 0) | (this.performBlockPhysics || o.performBlockPhysics ? 0 : 256) | (this.lighting || o.lighting ? 0 : 128) | (this.pathfindingUpdates || o.pathfindingUpdates ? 0 : 512);
        return BlockChangeFlagManager.fromNativeInt(maskedFlag);
    }

    @Override
    public SpongeBlockChangeFlag andNotFlag(BlockChangeFlag flag) {
        SpongeBlockChangeFlag o = (SpongeBlockChangeFlag)flag;
        int maskedFlag = (this.updateNeighbors && !o.updateNeighbors) | (this.notifyClients && !o.notifyClients ? 2 : 0) | (this.ignoreRender && !o.ignoreRender ? 4 : 0) | (this.forceReRender && !o.forceReRender ? 8 : 0) | (this.updateNeighborShapes && !o.updateNeighborShapes ? 0 : 16) | (this.neighborDrops && !o.neighborDrops ? 32 : 0) | (this.blockMoving && !o.blockMoving ? 64 : 0) | (this.performBlockPhysics && !o.performBlockPhysics ? 0 : 256) | (this.lighting && !o.lighting ? 0 : 128) | (this.pathfindingUpdates && !o.pathfindingUpdates ? 0 : 512);
        return BlockChangeFlagManager.fromNativeInt(maskedFlag);
    }

    @Override
    public BlockChangeFlag withNeighborDropsAllowed(boolean dropsAllowed) {
        if (this.neighborDrops == dropsAllowed) {
            return this;
        }
        int maskedFlag = (this.updateNeighbors ? 1 : 0) | (this.notifyClients ? 2 : 0) | (this.ignoreRender ? 4 : 0) | (this.forceReRender ? 8 : 0) | (this.updateNeighborShapes ? 0 : 16) | (dropsAllowed ? 0 : 32) | (this.blockMoving ? 64 : 0) | (this.performBlockPhysics ? 0 : 256) | (this.lighting ? 0 : 128) | (this.pathfindingUpdates ? 0 : 512);
        return BlockChangeFlagManager.fromNativeInt(maskedFlag);
    }

    @Override
    public BlockChangeFlag withBlocksMoving(boolean moving) {
        if (this.blockMoving == moving) {
            return this;
        }
        int maskedFlag = (this.updateNeighbors ? 1 : 0) | (this.notifyClients ? 2 : 0) | (this.ignoreRender ? 4 : 0) | (this.forceReRender ? 8 : 0) | (this.updateNeighborShapes ? 0 : 16) | (this.neighborDrops ? 0 : 32) | (moving ? 64 : 0) | (this.performBlockPhysics ? 0 : 256) | (this.lighting ? 0 : 128) | (this.pathfindingUpdates ? 0 : 512);
        return BlockChangeFlagManager.fromNativeInt(maskedFlag);
    }

    @Override
    public BlockChangeFlag withIgnoreRender(boolean ignoreRender) {
        if (this.ignoreRender == ignoreRender) {
            return this;
        }
        int maskedFlag = (this.updateNeighbors ? 1 : 0) | (this.notifyClients ? 2 : 0) | (ignoreRender ? 4 : 0) | (this.forceReRender ? 8 : 0) | (this.updateNeighborShapes ? 0 : 16) | (this.neighborDrops ? 0 : 32) | (this.blockMoving ? 64 : 0) | (this.performBlockPhysics ? 0 : 256) | (this.lighting ? 0 : 128) | (this.pathfindingUpdates ? 0 : 512);
        return BlockChangeFlagManager.fromNativeInt(maskedFlag);
    }

    @Override
    public BlockChangeFlag withForcedReRender(boolean forcedReRender) {
        if (this.forceReRender == this.ignoreRender) {
            return this;
        }
        int maskedFlag = (this.updateNeighbors ? 1 : 0) | (this.notifyClients ? 2 : 0) | (this.ignoreRender ? 4 : 0) | (forcedReRender ? 8 : 0) | (this.updateNeighborShapes ? 0 : 16) | (this.neighborDrops ? 0 : 32) | (this.blockMoving ? 64 : 0) | (this.performBlockPhysics ? 0 : 256) | (this.lighting ? 0 : 128) | (this.pathfindingUpdates ? 0 : 512);
        return BlockChangeFlagManager.fromNativeInt(maskedFlag);
    }

    public int getRawFlag() {
        return this.rawFlag;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("rawFlag", this.rawFlag).add("notifyNeighbors", this.updateNeighbors).add("notifyClients", this.notifyClients).add("performBlockPhysics", this.performBlockPhysics).add("updateNeighboringShapes", this.updateNeighborShapes).add("ignoreRender", this.ignoreRender).add("forceReRender", this.forceReRender).toString();
    }

    public SpongeBlockChangeFlag asNestedNeighborUpdates() {
        int maskedFlag = (this.notifyClients ? 2 : 0) | (this.ignoreRender ? 4 : 0) | (this.forceReRender ? 8 : 0) | (this.updateNeighborShapes ? 0 : 16) | (this.blockMoving ? 64 : 0) | (this.performBlockPhysics ? 0 : 256) | (this.lighting ? 0 : 128) | (this.pathfindingUpdates ? 0 : 512);
        return BlockChangeFlagManager.fromNativeInt(maskedFlag);
    }
}

