/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.world.schematic;

import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.spongepowered.api.block.BlockState;
import org.spongepowered.api.block.BlockType;
import org.spongepowered.api.block.entity.BlockEntityArchetype;
import org.spongepowered.api.data.persistence.DataView;
import org.spongepowered.api.entity.EntityArchetype;
import org.spongepowered.api.fluid.FluidState;
import org.spongepowered.api.util.transformation.Transformation;
import org.spongepowered.api.world.biome.Biome;
import org.spongepowered.api.world.schematic.Palette;
import org.spongepowered.api.world.schematic.Schematic;
import org.spongepowered.api.world.volume.archetype.ArchetypeVolume;
import org.spongepowered.api.world.volume.archetype.entity.EntityArchetypeEntry;
import org.spongepowered.api.world.volume.stream.StreamOptions;
import org.spongepowered.api.world.volume.stream.VolumeStream;
import org.spongepowered.common.data.holder.SpongeArchetypeVolumeDataHolder;
import org.spongepowered.common.world.schematic.ReferentSchematicVolume;
import org.spongepowered.common.world.volume.buffer.AbstractVolumeBuffer;
import org.spongepowered.common.world.volume.buffer.archetype.SpongeArchetypeVolume;
import org.spongepowered.math.vector.Vector3i;

public class SpongeSchematic
extends AbstractVolumeBuffer
implements Schematic,
SpongeArchetypeVolumeDataHolder {
    private final SpongeArchetypeVolume volume;
    private final DataView metadata;

    public SpongeSchematic(Vector3i start, Vector3i size, SpongeArchetypeVolume volume, DataView metadata) {
        super(start, size);
        this.volume = volume;
        this.metadata = metadata;
    }

    @Override
    public Palette<BlockState, BlockType> blockPalette() {
        return this.volume.getBlockPalette();
    }

    @Override
    public Palette<Biome, Biome> biomePalette() {
        return this.volume.getBiomePalette();
    }

    @Override
    public DataView metadata() {
        return this.metadata;
    }

    @Override
    public void addBlockEntity(int x, int y, int z, BlockEntityArchetype archetype) {
        this.volume.addBlockEntity(x, y, z, archetype);
    }

    @Override
    public void removeBlockEntity(int x, int y, int z) {
        this.volume.removeBlockEntity(x, y, z);
    }

    @Override
    public Optional<BlockEntityArchetype> blockEntityArchetype(int x, int y, int z) {
        return this.volume.blockEntityArchetype(x, y, z);
    }

    @Override
    public Map<Vector3i, BlockEntityArchetype> blockEntityArchetypes() {
        return this.volume.blockEntityArchetypes();
    }

    @Override
    public VolumeStream<ArchetypeVolume, BlockEntityArchetype> blockEntityArchetypeStream(Vector3i min, Vector3i max, StreamOptions options) {
        return this.volume.blockEntityArchetypeStream(min, max, options);
    }

    @Override
    public Collection<EntityArchetype> entityArchetypes() {
        return this.volume.entityArchetypes();
    }

    @Override
    public Collection<EntityArchetypeEntry> entityArchetypesByPosition() {
        return this.volume.entityArchetypesByPosition();
    }

    @Override
    public Collection<EntityArchetype> entityArchetypes(Predicate<EntityArchetype> filter) {
        return this.volume.entityArchetypes(filter);
    }

    @Override
    public VolumeStream<ArchetypeVolume, EntityArchetype> entityArchetypeStream(Vector3i min, Vector3i max, StreamOptions options) {
        return this.volume.entityArchetypeStream(min, max, options);
    }

    @Override
    public Stream<EntityArchetypeEntry> entitiesByPosition() {
        return this.volume.entitiesByPosition();
    }

    @Override
    public boolean setBlock(int x, int y, int z, BlockState block) {
        return this.volume.setBlock(x, y, z, block);
    }

    @Override
    public boolean removeBlock(int x, int y, int z) {
        return this.volume.removeBlock(x, y, z);
    }

    @Override
    public BlockState block(int x, int y, int z) {
        return this.volume.block(x, y, z);
    }

    @Override
    public FluidState fluid(int x, int y, int z) {
        return this.volume.fluid(x, y, z);
    }

    @Override
    public int highestYAt(int x, int z) {
        return this.volume.highestYAt(x, z);
    }

    @Override
    public VolumeStream<ArchetypeVolume, BlockState> blockStateStream(Vector3i min, Vector3i max, StreamOptions options) {
        return this.volume.blockStateStream(min, max, options);
    }

    @Override
    public void addEntity(EntityArchetypeEntry entry) {
        this.volume.addEntity(entry);
    }

    @Override
    public Biome biome(int x, int y, int z) {
        return this.volume.biome(x, y, z);
    }

    @Override
    public VolumeStream<ArchetypeVolume, Biome> biomeStream(Vector3i min, Vector3i max, StreamOptions options) {
        return this.volume.biomeStream(min, max, options);
    }

    @Override
    public boolean setBiome(int x, int y, int z, Biome biome) {
        return this.volume.setBiome(x, y, z, biome);
    }

    @Override
    public ArchetypeVolume transform(Transformation transformation) {
        return new ReferentSchematicVolume(this, Objects.requireNonNull(transformation, "Transformation cannot be null"));
    }
}

