/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.mlpatcher;

import java.lang.instrument.ClassFileTransformer;
import java.lang.instrument.IllegalClassFormatException;
import java.lang.instrument.Instrumentation;
import java.security.ProtectionDomain;
import java.util.Map;
import java.util.Set;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.MethodVisitor;

public class AsmFixerAgent {
    private static final int ASM_VERSION = 589824;
    private static Instrumentation instrumentation;

    public static void premain(String agentArgs, Instrumentation instrumentation) {
        AsmFixerAgent.instrumentation = instrumentation;
        AsmFixerAgent.setup();
    }

    public static void agentmain(String agentArgs, Instrumentation instrumentation) {
        AsmFixerAgent.instrumentation = instrumentation;
        AsmFixerAgent.setup();
    }

    private static void setup() {
        instrumentation.addTransformer(new MLFixer());
    }

    private AsmFixerAgent() {
    }

    private static class MLFixer
    implements ClassFileTransformer {
        private final Map<String, PatchInfo> patch = Map.of("cpw/mods/modlauncher/TransformerClassWriter$SuperCollectingVisitor", new PatchInfo("<init>"), "cpw/mods/modlauncher/ClassTransformer", new PatchInfo("transform"), "cpw/mods/modlauncher/PredicateVisitor", new PatchInfo("<init>"));

        private MLFixer() {
        }

        @Override
        public byte[] transform(Module module, ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws IllegalClassFormatException {
            if (!this.patch.containsKey(className)) {
                return classfileBuffer;
            }
            ClassReader reader = new ClassReader(classfileBuffer);
            ClassWriter writer = new ClassWriter(reader, 0);
            reader.accept(new Cls(writer, this.patch.get(className)), 0);
            return writer.toByteArray();
        }

        record PatchInfo(Set<String> methodsToPatch) {
            public PatchInfo(String ... methods) {
                this(Set.of(methods));
            }
        }

        private static class Cls
        extends ClassVisitor {
            private final PatchInfo data;

            public Cls(ClassVisitor parent, PatchInfo data) {
                super(589824, parent);
                this.data = data;
            }

            @Override
            public MethodVisitor visitMethod(int access, String name, String descriptor, String signature, String[] exceptions) {
                MethodVisitor parent = super.visitMethod(access, name, descriptor, signature, exceptions);
                if (this.data.methodsToPatch.contains(name)) {
                    return new Method(parent);
                }
                return parent;
            }
        }

        private static class Method
        extends MethodVisitor {
            public Method(MethodVisitor parent) {
                super(589824, parent);
            }

            @Override
            public void visitLdcInsn(Object value) {
                if (value instanceof Integer && (Integer)value == 458752) {
                    super.visitLdcInsn(589824);
                } else {
                    super.visitLdcInsn(value);
                }
            }
        }
    }
}

