/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.vanilla.chat.console;

import com.mojang.brigadier.CommandDispatcher;
import java.util.function.Supplier;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.dedicated.DedicatedServer;
import net.minecrell.terminalconsole.SimpleTerminalConsole;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.jline.reader.LineReader;
import org.jline.reader.LineReaderBuilder;
import org.spongepowered.common.command.manager.SpongeCommandManager;
import org.spongepowered.common.launch.Launch;
import org.spongepowered.vanilla.chat.console.BrigadierHighlighter;
import org.spongepowered.vanilla.chat.console.BrigadierJLineCompleter;

public final class VanillaConsole
extends SimpleTerminalConsole {
    private final DedicatedServer server;

    public VanillaConsole(DedicatedServer server) {
        this.server = server;
    }

    protected LineReader buildReader(LineReaderBuilder builder) {
        Supplier<@Nullable CommandDispatcher<S>> dispatcherProvider = () -> {
            SpongeCommandManager manager = SpongeCommandManager.get((MinecraftServer)this.server);
            return manager == null ? null : manager.getDispatcher();
        };
        Supplier<CommandSourceStack> commandSourceProvider = () -> ((DedicatedServer)this.server).createCommandSourceStack();
        return super.buildReader(builder.appName((String)((Launch)Launch.instance()).platformPlugin().metadata().name().get()).completer(new BrigadierJLineCompleter<CommandSourceStack>(dispatcherProvider, commandSourceProvider)).highlighter(new BrigadierHighlighter<CommandSourceStack>(dispatcherProvider, commandSourceProvider)).option(LineReader.Option.COMPLETE_IN_WORD, true));
    }

    protected boolean isRunning() {
        return !this.server.isStopped() && this.server.isRunning();
    }

    protected void runCommand(String command) {
        this.server.handleConsoleInput(command, this.server.createCommandSourceStack());
    }

    protected void shutdown() {
        this.server.halt(true);
    }
}

