/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.api.block;

import java.util.Objects;
import java.util.function.Supplier;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.block.BlockSnapshot;
import org.spongepowered.api.block.BlockType;
import org.spongepowered.api.data.DirectionRelativeDataHolder;
import org.spongepowered.api.fluid.FluidState;
import org.spongepowered.api.state.State;
import org.spongepowered.api.state.StateMatcher;
import org.spongepowered.api.util.mirror.Mirror;
import org.spongepowered.api.util.rotation.Rotation;
import org.spongepowered.api.world.server.ServerLocation;

public interface BlockState
extends State<BlockState>,
DirectionRelativeDataHolder.Immutable<BlockState> {
    public static Builder builder() {
        return Sponge.game().builderProvider().provide(Builder.class);
    }

    public static BlockState fromString(String id) {
        Objects.requireNonNull(id);
        return (BlockState)((Builder)Sponge.game().builderProvider().provide(Builder.class).fromString(id)).build();
    }

    public static StateMatcher.Builder<BlockState, BlockType> matcher(Supplier<? extends BlockType> type) {
        return BlockState.matcher(type.get());
    }

    public static StateMatcher.Builder<BlockState, BlockType> matcher(BlockType type) {
        return StateMatcher.blockStateMatcherBuilder().type(type);
    }

    public BlockType type();

    public FluidState fluidState();

    public BlockSnapshot snapshotFor(ServerLocation var1);

    public BlockState rotate(Rotation var1);

    default public BlockState rotate(Supplier<? extends Rotation> rotation) {
        return this.rotate(rotation.get());
    }

    public BlockState mirror(Mirror var1);

    default public BlockState mirror(Supplier<? extends Mirror> mirror) {
        return this.mirror(mirror.get());
    }

    public String asString();

    public static interface Builder
    extends State.Builder<BlockState, Builder> {
        default public Builder blockType(Supplier<? extends BlockType> blockType) {
            return this.blockType(blockType.get());
        }

        public Builder blockType(BlockType var1);
    }
}

