/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.api.util;

import org.checkerframework.checker.nullness.qual.Nullable;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum Tristate {
    TRUE(true){

        @Override
        public Tristate and(Tristate other) {
            return other == FALSE ? FALSE : TRUE;
        }

        @Override
        public Tristate or(Tristate other) {
            return TRUE;
        }

        @Override
        public Tristate not() {
            return FALSE;
        }
    }
    ,
    FALSE(false){

        @Override
        public Tristate and(Tristate other) {
            return FALSE;
        }

        @Override
        public Tristate or(Tristate other) {
            return other == TRUE ? TRUE : FALSE;
        }

        @Override
        public Tristate not() {
            return TRUE;
        }
    }
    ,
    UNDEFINED(false){

        @Override
        public Tristate and(Tristate other) {
            return other;
        }

        @Override
        public Tristate or(Tristate other) {
            return other;
        }

        @Override
        public Tristate not() {
            return UNDEFINED;
        }
    };

    private final boolean val;

    private Tristate(boolean val) {
        this.val = val;
    }

    public static Tristate fromBoolean(boolean val) {
        return val ? TRUE : FALSE;
    }

    public static Tristate fromNullableBoolean(@Nullable Boolean val) {
        if (val == null) {
            return UNDEFINED;
        }
        return val != false ? TRUE : FALSE;
    }

    public abstract Tristate and(Tristate var1);

    public abstract Tristate or(Tristate var1);

    public abstract Tristate not();

    public boolean asBoolean() {
        return this.val;
    }

    public @Nullable Boolean asNullableBoolean() {
        if (this == UNDEFINED) {
            return null;
        }
        return this.val;
    }
}

