/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.api.world;

import java.util.Optional;
import org.spongepowered.api.block.BlockType;
import org.spongepowered.api.data.DataHolder;
import org.spongepowered.api.data.Keys;
import org.spongepowered.api.registry.DefaultedRegistryValue;
import org.spongepowered.api.service.context.ContextSource;
import org.spongepowered.api.tag.Tag;
import org.spongepowered.api.util.MinecraftDayTime;
import org.spongepowered.api.util.Range;
import org.spongepowered.api.util.annotation.CatalogedBy;
import org.spongepowered.api.world.WorldTypeEffect;
import org.spongepowered.api.world.WorldTypes;

@CatalogedBy(value={WorldTypes.class})
public interface WorldType
extends DefaultedRegistryValue,
ContextSource,
DataHolder {
    default public WorldTypeEffect effect() {
        return this.require(Keys.WORLD_TYPE_EFFECT);
    }

    default public boolean scorching() {
        return this.require(Keys.SCORCHING);
    }

    default public boolean natural() {
        return this.require(Keys.NATURAL_WORLD_TYPE);
    }

    default public double coordinateMultiplier() {
        return this.require(Keys.COORDINATE_MULTIPLIER);
    }

    default public boolean hasSkylight() {
        return this.require(Keys.HAS_SKYLIGHT);
    }

    default public boolean hasCeiling() {
        return this.require(Keys.HAS_CEILING);
    }

    default public float ambientLighting() {
        return this.require(Keys.AMBIENT_LIGHTING).floatValue();
    }

    default public Optional<MinecraftDayTime> fixedTime() {
        return this.get(Keys.FIXED_TIME);
    }

    default public boolean piglinSafe() {
        return this.require(Keys.PIGLIN_SAFE);
    }

    default public boolean bedsUsable() {
        return this.require(Keys.BEDS_USABLE);
    }

    default public boolean respawnAnchorsUsable() {
        return this.require(Keys.RESPAWN_ANCHOR_USABLE);
    }

    default public boolean hasRaids() {
        return this.require(Keys.HAS_RAIDS);
    }

    default public int floor() {
        return this.require(Keys.WORLD_FLOOR);
    }

    default public int height() {
        return this.require(Keys.WORLD_HEIGHT);
    }

    default public int logicalHeight() {
        return this.require(Keys.WORLD_LOGICAL_HEIGHT);
    }

    default public Tag<BlockType> infiniburn() {
        return this.require(Keys.INFINIBURN);
    }

    default public boolean createDragonFight() {
        return this.require(Keys.CREATE_DRAGON_FIGHT);
    }

    default public int spawnLightLimit() {
        return this.require(Keys.SPAWN_LIGHT_LIMIT);
    }

    default public Range<Integer> spawnLightRange() {
        return this.require(Keys.SPAWN_LIGHT_RANGE);
    }
}

