/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.api.world.generation.config;

import java.util.List;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.block.BlockState;
import org.spongepowered.api.registry.RegistryReference;
import org.spongepowered.api.world.biome.Biome;
import org.spongepowered.api.world.generation.config.noise.Noise;

public interface SurfaceRule {
    public static SurfaceRule overworld() {
        return Sponge.game().factoryProvider().provide(Factory.class).overworld();
    }

    public static SurfaceRule overworldLike(boolean nearSurface, boolean bedrockRoof, boolean bedrockFloor) {
        return Sponge.game().factoryProvider().provide(Factory.class).overworldLike(nearSurface, bedrockRoof, bedrockFloor);
    }

    public static SurfaceRule nether() {
        return Sponge.game().factoryProvider().provide(Factory.class).nether();
    }

    public static SurfaceRule end() {
        return Sponge.game().factoryProvider().provide(Factory.class).end();
    }

    public static interface Factory {
        public SurfaceRule overworld();

        public SurfaceRule overworldLike(boolean var1, boolean var2, boolean var3);

        public SurfaceRule nether();

        public SurfaceRule end();

        public SurfaceRule firstOf(List<SurfaceRule> var1);

        public SurfaceRule firstOf(SurfaceRule ... var1);

        public SurfaceRule badlands();

        public SurfaceRule block(BlockState var1);

        public SurfaceRule test(List<Condition> var1, SurfaceRule var2);

        public SurfaceRule test(Condition var1, SurfaceRule var2);

        public Condition not(Condition var1);

        public Condition liquidDepth(int var1, int var2);

        public Condition liquidDepthFromSurface(int var1, int var2);

        public Condition biome(List<RegistryReference<Biome>> var1);

        public Condition nearSurface();

        public Condition hole();

        public Condition verticalGradient(String var1, int var2, int var3);

        public Condition verticalGradient(String var1, VerticalAnchor var2, VerticalAnchor var3);

        public Condition steep();

        public Condition onFloor();

        public Condition underFloor(int var1);

        public Condition floor(int var1, boolean var2, int var3);

        public Condition onCeiling();

        public Condition underCeiling(int var1);

        public Condition ceiling(int var1, boolean var2, int var3);

        public Condition snowyTemperature();

        public Condition blockAbove(VerticalAnchor var1, int var2);

        public Condition surfaceAbove(VerticalAnchor var1, int var2);

        public Condition noiseThreshold(RegistryReference<Noise> var1, double var2, double var4);

        public VerticalAnchor absolute(int var1);

        public VerticalAnchor top();

        public VerticalAnchor belowTop(int var1);

        public VerticalAnchor bottom();

        public VerticalAnchor aboveBottom(int var1);
    }

    public static interface Condition {
        public SurfaceRule then(SurfaceRule var1);

        public Condition not();
    }

    public static interface VerticalAnchor {
    }
}

