/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.api.world.server;

import java.io.IOException;
import java.util.Optional;
import net.kyori.adventure.text.Component;
import org.spongepowered.api.ResourceKeyed;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.data.DataHolder;
import org.spongepowered.api.data.Key;
import org.spongepowered.api.data.Keys;
import org.spongepowered.api.data.persistence.DataView;
import org.spongepowered.api.data.value.Value;
import org.spongepowered.api.datapack.DataPack;
import org.spongepowered.api.datapack.DataPackEntry;
import org.spongepowered.api.entity.living.player.gamemode.GameMode;
import org.spongepowered.api.util.CopyableBuilder;
import org.spongepowered.api.util.ResourceKeyedBuilder;
import org.spongepowered.api.world.SerializationBehavior;
import org.spongepowered.api.world.WorldType;
import org.spongepowered.api.world.difficulty.Difficulty;
import org.spongepowered.api.world.generation.ChunkGenerator;
import org.spongepowered.api.world.server.ServerWorld;
import org.spongepowered.api.world.server.storage.ServerWorldProperties;
import org.spongepowered.math.vector.Vector3i;

public interface WorldTemplate
extends ResourceKeyed,
DataPackEntry<WorldTemplate>,
DataHolder {
    public static WorldTemplate overworld() {
        return Sponge.game().factoryProvider().provide(Factory.class).overworld();
    }

    public static WorldTemplate overworldCaves() {
        return Sponge.game().factoryProvider().provide(Factory.class).overworldCaves();
    }

    public static WorldTemplate theNether() {
        return Sponge.game().factoryProvider().provide(Factory.class).theNether();
    }

    public static WorldTemplate theEnd() {
        return Sponge.game().factoryProvider().provide(Factory.class).theEnd();
    }

    public static Builder builder() {
        return (Builder)Sponge.game().builderProvider().provide(Builder.class).reset();
    }

    default public Optional<Component> displayName() {
        return this.get(Keys.DISPLAY_NAME);
    }

    default public WorldType worldType() {
        return (WorldType)this.require(Keys.WORLD_TYPE);
    }

    default public ChunkGenerator generator() {
        return (ChunkGenerator)this.require(Keys.CHUNK_GENERATOR);
    }

    default public Optional<GameMode> gameMode() {
        return this.get(Keys.GAME_MODE);
    }

    default public Optional<Difficulty> difficulty() {
        return this.get(Keys.WORLD_DIFFICULTY);
    }

    default public Optional<SerializationBehavior> serializationBehavior() {
        return this.get(Keys.SERIALIZATION_BEHAVIOR);
    }

    default public boolean loadOnStartup() {
        return (Boolean)this.require(Keys.IS_LOAD_ON_STARTUP);
    }

    default public boolean performsSpawnLogic() {
        return (Boolean)this.require(Keys.PERFORM_SPAWN_LOGIC);
    }

    default public Optional<Boolean> hardcore() {
        return this.get(Keys.HARDCORE);
    }

    default public Optional<Boolean> commands() {
        return this.get(Keys.COMMANDS);
    }

    default public Optional<Boolean> pvp() {
        return this.get(Keys.PVP);
    }

    default public Optional<Integer> viewDistance() {
        return this.get(Keys.VIEW_DISTANCE);
    }

    default public Optional<Vector3i> spawnPosition() {
        return this.get(Keys.SPAWN_POSITION);
    }

    default public Optional<Long> seed() {
        return this.get(Keys.SEED);
    }

    default public Optional<Boolean> createDragonFight() {
        return this.get(Keys.CREATE_DRAGON_FIGHT);
    }

    default public Builder asBuilder() {
        return (Builder)Sponge.game().builderProvider().provide(Builder.class).from(this);
    }

    public static interface Factory {
        public WorldTemplate overworld();

        public WorldTemplate overworldCaves();

        public WorldTemplate theNether();

        public WorldTemplate theEnd();
    }

    public static interface Builder
    extends ResourceKeyedBuilder<WorldTemplate, Builder>,
    CopyableBuilder<WorldTemplate, Builder> {
        public <V> Builder add(Key<? extends Value<V>> var1, V var2);

        public Builder fromDataPack(DataView var1) throws IOException;

        @Override
        public Builder from(ServerWorld var1);

        @Override
        public Builder from(ServerWorldProperties var1);

        public Builder pack(DataPack<WorldTemplate> var1);
    }
}

