/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.api.world.volume.stream;

import org.spongepowered.api.Sponge;

public interface StreamOptions {
    public static Builder builder() {
        return Sponge.game().builderProvider().provide(Builder.class);
    }

    public static StreamOptions lazily() {
        return StreamOptions.builder().setCarbonCopy(false).setLoadingStyle(LoadingStyle.LAZILY_UNGENERATED).build();
    }

    public static StreamOptions forceLoadedAndCopied() {
        return StreamOptions.builder().setCarbonCopy(true).setLoadingStyle(LoadingStyle.FORCED_GENERATED).build();
    }

    public boolean carbonCopy();

    public LoadingStyle loadingStyle();

    public static interface Builder
    extends org.spongepowered.api.util.Builder<StreamOptions, Builder> {
        public Builder setCarbonCopy(boolean var1);

        public Builder setLoadingStyle(LoadingStyle var1);

        public StreamOptions build();
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static enum LoadingStyle {
        FORCED_GENERATED{

            @Override
            public boolean generateArea() {
                return true;
            }

            @Override
            public boolean immediateLoading() {
                return true;
            }
        }
        ,
        FORCED_UNGENERATED{

            @Override
            public boolean generateArea() {
                return false;
            }

            @Override
            public boolean immediateLoading() {
                return true;
            }
        }
        ,
        LAZILY_UNGENERATED{

            @Override
            public boolean generateArea() {
                return false;
            }

            @Override
            public boolean immediateLoading() {
                return false;
            }
        }
        ,
        LAZILY_GENERATED{

            @Override
            public boolean generateArea() {
                return true;
            }

            @Override
            public boolean immediateLoading() {
                return false;
            }
        }
        ,
        NONE{

            @Override
            public boolean generateArea() {
                return false;
            }

            @Override
            public boolean immediateLoading() {
                return false;
            }
        };


        public abstract boolean generateArea();

        public abstract boolean immediateLoading();
    }
}

