/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.api.world.volume.stream;

import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.spongepowered.api.block.BlockState;
import org.spongepowered.api.util.rotation.Rotation;
import org.spongepowered.api.world.volume.Volume;
import org.spongepowered.api.world.volume.stream.VolumeElement;
import org.spongepowered.api.world.volume.stream.VolumePositionTranslator;
import org.spongepowered.math.imaginary.Quaterniond;
import org.spongepowered.math.vector.Vector3d;
import org.spongepowered.math.vector.Vector3i;

public final class VolumePositionTranslators {
    public static final Vector3d BLOCK_OFFSET = new Vector3d(0.5, 0.5, 0.5);

    public static <W extends Volume, E> VolumePositionTranslator<W, E> identity() {
        return element -> element;
    }

    public static <W extends Volume> VolumePositionTranslator<W, BlockState> rotateBlocksOn(Vector3i start, Vector3d center, Rotation rotation) {
        return VolumePositionTranslators.rotateOn(start, center, rotation, (position, state) -> state.rotate(rotation));
    }

    public static <W extends Volume, E> VolumePositionTranslator<W, E> rotateOn(Vector3i start, Vector3d center, Rotation rotation, BiFunction<Vector3d, E, E> elementRotation) {
        return element -> {
            Quaterniond q = Quaterniond.fromAngleDegAxis((double)rotation.angle().degrees(), (double)0.0, (double)1.0, (double)0.0);
            Vector3d v = q.rotate(center).add(element.position().sub(start.toDouble()));
            return VolumeElement.of(element.volume(), elementRotation.apply(v, element.type()), v);
        };
    }

    public static <W extends Volume, E> VolumePositionTranslator<W, E> relativeTo(Vector3i newOrigin) {
        return VolumePositionTranslators.relativeTo(newOrigin.toDouble().sub(BLOCK_OFFSET));
    }

    public static <W extends Volume, E> VolumePositionTranslator<W, E> relativeTo(Vector3d newOrigin) {
        return element -> VolumeElement.of(element.volume(), element.type(), element.position().add(newOrigin));
    }

    public static <W extends Volume, E> VolumePositionTranslator<W, E> offset(Vector3i min) {
        return VolumePositionTranslators.offset(min.toDouble().add(BLOCK_OFFSET));
    }

    public static <W extends Volume, E> VolumePositionTranslator<W, E> offset(Vector3d min) {
        return element -> VolumeElement.of(element.volume(), element.type(), element.position().sub(min));
    }

    public static <W extends Volume, E> VolumePositionTranslator<W, E> position(Function<Vector3d, Vector3d> func) {
        Objects.requireNonNull(func, "Position function cannot be null!");
        return element -> VolumeElement.of(element.volume(), element.type(), (Vector3d)func.apply(element.position()));
    }

    private VolumePositionTranslators() {
    }
}

