/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.api.world.volume.virtual;

import java.util.Objects;
import java.util.Optional;
import org.spongepowered.api.ResourceKey;
import org.spongepowered.api.registry.Registry;
import org.spongepowered.api.world.volume.ImmutableVolume;
import org.spongepowered.api.world.volume.MutableVolume;
import org.spongepowered.api.world.volume.UnmodifiableVolume;
import org.spongepowered.api.world.volume.Volume;
import org.spongepowered.api.world.volume.biome.BiomeVolume;
import org.spongepowered.api.world.volume.stream.StreamOptions;
import org.spongepowered.api.world.volume.stream.VolumeStream;
import org.spongepowered.math.vector.Vector3i;

public interface Virtualized<T, R extends Volume>
extends Volume {
    public R realize(Registry<T> var1);

    default public ResourceKey at(Vector3i position) {
        Objects.requireNonNull(position, "position");
        return this.at(position.x(), position.y(), position.z());
    }

    public ResourceKey at(int var1, int var2, int var3);

    default public Optional<T> at(Vector3i position, Registry<T> registry) {
        return registry.findValue(this.at(position));
    }

    default public Optional<T> at(int x, int y, int z, Registry<T> registry) {
        return registry.findValue(this.at(x, y, z));
    }

    public static interface Immutable
    extends BiomeVolume.Unmodifiable<BiomeVolume.Immutable>,
    ImmutableVolume {
    }

    public static interface Mutable<T, M extends Mutable<T, M, MU>, MU extends Volume>
    extends Streamable<T, M, MU>,
    MutableVolume {
        default public boolean set(Vector3i position, Registry<T> registry, T element) {
            return registry.findValueKey(element).map(resource -> this.set(position.x(), position.y(), position.z(), (ResourceKey)resource)).orElse(false);
        }

        public boolean set(int var1, int var2, int var3, ResourceKey var4);
    }

    public static interface Unmodifiable<T, U extends Unmodifiable<T, U, RU>, RU extends Volume>
    extends Virtualized<T, RU>,
    Streamable<T, U, RU>,
    UnmodifiableVolume {
    }

    public static interface Streamable<T, B extends Streamable<T, B, S>, S extends Volume>
    extends Virtualized<T, S> {
        public VolumeStream<B, ResourceKey> elementStream(Vector3i var1, Vector3i var2, StreamOptions var3);
    }
}

