/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.adventure;

import com.mojang.brigadier.Message;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.codecs.PrimitiveCodec;
import io.netty.util.AttributeKey;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.audience.ForwardingAudience;
import net.kyori.adventure.audience.MessageType;
import net.kyori.adventure.bossbar.BossBar;
import net.kyori.adventure.chat.ChatType;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.nbt.api.BinaryTagHolder;
import net.kyori.adventure.serializer.configurate4.ConfigurateComponentSerializer;
import net.kyori.adventure.sound.Sound;
import net.kyori.adventure.text.BlockNBTComponent;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentBuilder;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.EntityNBTComponent;
import net.kyori.adventure.text.KeybindComponent;
import net.kyori.adventure.text.NBTComponent;
import net.kyori.adventure.text.ScoreComponent;
import net.kyori.adventure.text.SelectorComponent;
import net.kyori.adventure.text.StorageNBTComponent;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.TranslatableComponent;
import net.kyori.adventure.text.event.ClickEvent;
import net.kyori.adventure.text.event.HoverEvent;
import net.kyori.adventure.text.flattener.ComponentFlattener;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.Style;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.format.TextDecoration;
import net.kyori.adventure.text.renderer.ComponentRenderer;
import net.kyori.adventure.text.serializer.ComponentSerializer;
import net.kyori.adventure.text.serializer.gson.GsonComponentSerializer;
import net.kyori.adventure.translation.GlobalTranslator;
import net.kyori.adventure.util.Codec;
import net.kyori.adventure.util.TriState;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.TagParser;
import net.minecraft.network.chat.ChatType;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.contents.BlockDataSource;
import net.minecraft.network.chat.contents.DataSource;
import net.minecraft.network.chat.contents.EntityDataSource;
import net.minecraft.network.chat.contents.KeybindContents;
import net.minecraft.network.chat.contents.LiteralContents;
import net.minecraft.network.chat.contents.NbtContents;
import net.minecraft.network.chat.contents.ScoreContents;
import net.minecraft.network.chat.contents.SelectorContents;
import net.minecraft.network.chat.contents.StorageDataSource;
import net.minecraft.network.chat.contents.TranslatableContents;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerBossEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.BossEvent;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.adventure.ResolveOperation;
import org.spongepowered.api.adventure.SpongeComponents;
import org.spongepowered.api.command.CommandCause;
import org.spongepowered.api.entity.Entity;
import org.spongepowered.api.registry.DefaultedRegistryReference;
import org.spongepowered.api.util.Tristate;
import org.spongepowered.common.SpongeCommon;
import org.spongepowered.common.accessor.network.chat.HoverEvent_ItemStackInfoAccessor;
import org.spongepowered.common.accessor.network.chat.StyleAccessor;
import org.spongepowered.common.adventure.AdventureTextComponent;
import org.spongepowered.common.adventure.CallbackCommand;
import org.spongepowered.common.adventure.ComponentFlattenerProvider;
import org.spongepowered.common.adventure.SpongeResolveOperation;
import org.spongepowered.common.bridge.adventure.BossBarBridge;
import org.spongepowered.common.bridge.adventure.ComponentBridge;
import org.spongepowered.common.bridge.adventure.StyleBridge;
import org.spongepowered.common.bridge.world.BossEventBridge;
import org.spongepowered.common.launch.Launch;

public final class SpongeAdventure {
    public static final AttributeKey<Locale> CHANNEL_LOCALE = AttributeKey.newInstance((String)"sponge:locale");
    public static final Codec<CompoundTag, String, IOException, IOException> NBT_CODEC = new Codec<CompoundTag, String, IOException, IOException>(){

        public @NonNull CompoundTag decode(@NonNull String encoded) throws IOException {
            try {
                return TagParser.parseTag((String)encoded);
            }
            catch (CommandSyntaxException e) {
                throw new IOException(e);
            }
        }

        public @NonNull String encode(@NonNull CompoundTag decoded) {
            return decoded.toString();
        }
    };
    public static final PrimitiveCodec<Component> STRING_CODEC = new PrimitiveCodec<Component>(){

        public <T> DataResult<Component> read(DynamicOps<T> ops, T input) {
            return ops.getStringValue(input).map(arg_0 -> ((GsonComponentSerializer)GsonComponentSerializer.gson()).deserialize(arg_0));
        }

        public <T> T write(DynamicOps<T> ops, Component value) {
            return (T)ops.createString((String)GsonComponentSerializer.gson().serialize(value));
        }

        public String toString() {
            return "String[Component]";
        }
    };
    public static final ConfigurateComponentSerializer CONFIGURATE = ConfigurateComponentSerializer.builder().scalarSerializer((ComponentSerializer)GsonComponentSerializer.gson()).build();
    private static final Set<ServerBossEvent> ACTIVE_BOSS_BARS = ConcurrentHashMap.newKeySet();

    public static TriState asAdventure(Tristate state) {
        if (state == Tristate.UNDEFINED) {
            return TriState.NOT_SET;
        }
        if (state == Tristate.FALSE) {
            return TriState.FALSE;
        }
        if (state == Tristate.TRUE) {
            return TriState.TRUE;
        }
        throw new IllegalArgumentException(state.name());
    }

    public static Key asAdventure(ResourceLocation key) {
        return (Key)key;
    }

    public static ChatType.Bound asVanilla(RegistryAccess access, ChatType.Bound adv) {
        ChatType.Bound bound = adv;
        if (bound instanceof ChatType.Bound) {
            ChatType.Bound vanilla = (ChatType.Bound)bound;
            return vanilla;
        }
        ChatType.Bound vanilla = ChatType.bind((ResourceKey)ResourceKey.create((ResourceKey)Registries.CHAT_TYPE, (ResourceLocation)SpongeAdventure.asVanilla(adv.type().key())), (RegistryAccess)access, (net.minecraft.network.chat.Component)SpongeAdventure.asVanilla(adv.name()));
        if (adv.target() != null) {
            vanilla = vanilla.withTargetName(SpongeAdventure.asVanilla(adv.target()));
        }
        return vanilla;
    }

    public static @Nullable net.minecraft.network.chat.Component asVanillaNullable(@Nullable Component component) {
        if (component == null) {
            return null;
        }
        return SpongeAdventure.asVanilla(component);
    }

    public static net.minecraft.network.chat.Component asVanilla(Component component) {
        return new AdventureTextComponent(component, (ComponentRenderer<Locale>)GlobalTranslator.renderer());
    }

    public static Optional<net.minecraft.network.chat.Component> asVanillaOpt(@Nullable Component component) {
        return component == null ? Optional.empty() : Optional.of(((ComponentBridge)component).bridge$asVanillaComponent());
    }

    public static MutableComponent asVanillaMutable(Component component) {
        MutableComponent vanilla = SpongeAdventure.asVanillaMutable0(component);
        for (Component child : component.children()) {
            vanilla.append(((ComponentBridge)child).bridge$asVanillaComponent());
        }
        vanilla.setStyle(((StyleBridge)component.style()).bridge$asVanilla());
        return vanilla;
    }

    private static MutableComponent asVanillaMutable0(Component component) {
        if (component instanceof TextComponent) {
            return net.minecraft.network.chat.Component.literal((String)((TextComponent)component).content());
        }
        if (component instanceof TranslatableComponent) {
            TranslatableComponent $this = (TranslatableComponent)component;
            ArrayList<net.minecraft.network.chat.Component> with = new ArrayList<net.minecraft.network.chat.Component>($this.args().size());
            for (Component arg : $this.args()) {
                with.add(((ComponentBridge)arg).bridge$asVanillaComponent());
            }
            return net.minecraft.network.chat.Component.translatable((String)$this.key(), (Object[])with.toArray(new Object[0]));
        }
        if (component instanceof KeybindComponent) {
            return net.minecraft.network.chat.Component.keybind((String)((KeybindComponent)component).keybind());
        }
        if (component instanceof ScoreComponent) {
            ScoreComponent $this = (ScoreComponent)component;
            return net.minecraft.network.chat.Component.score((String)$this.name(), (String)$this.objective());
        }
        if (component instanceof SelectorComponent) {
            SelectorComponent $this = (SelectorComponent)component;
            return net.minecraft.network.chat.Component.selector((String)$this.pattern(), SpongeAdventure.asVanillaOpt($this.separator()));
        }
        if (component instanceof NBTComponent) {
            if (component instanceof BlockNBTComponent) {
                BlockNBTComponent $this = (BlockNBTComponent)component;
                return net.minecraft.network.chat.Component.nbt((String)$this.nbtPath(), (boolean)$this.interpret(), SpongeAdventure.asVanillaOpt($this.separator()), (DataSource)new BlockDataSource($this.pos().asString()));
            }
            if (component instanceof EntityNBTComponent) {
                EntityNBTComponent $this = (EntityNBTComponent)component;
                return net.minecraft.network.chat.Component.nbt((String)$this.nbtPath(), (boolean)$this.interpret(), SpongeAdventure.asVanillaOpt($this.separator()), (DataSource)new EntityDataSource($this.selector()));
            }
            if (component instanceof StorageNBTComponent) {
                StorageNBTComponent $this = (StorageNBTComponent)component;
                return net.minecraft.network.chat.Component.nbt((String)$this.nbtPath(), (boolean)$this.interpret(), SpongeAdventure.asVanillaOpt($this.separator()), (DataSource)new StorageDataSource(SpongeAdventure.asVanilla($this.storage())));
            }
        }
        throw new UnsupportedOperationException("Cannot convert Component of type " + component.getClass());
    }

    public static Component asAdventure(net.minecraft.network.chat.Component component) {
        if (component instanceof AdventureTextComponent) {
            AdventureTextComponent ac = (AdventureTextComponent)component;
            return ac.wrapped();
        }
        ComponentBuilder<?, ?> builder = SpongeAdventure.asAdventureBuilder(component.getContents());
        for (net.minecraft.network.chat.Component child : component.getSiblings()) {
            builder.append(SpongeAdventure.asAdventure(child));
        }
        builder.style(((org.spongepowered.common.bridge.network.chat.StyleBridge)component.getStyle()).bridge$asAdventure());
        return builder.build();
    }

    private static ComponentBuilder<?, ?> asAdventureBuilder(ComponentContents contents) {
        if (contents instanceof LiteralContents) {
            LiteralContents lc = (LiteralContents)contents;
            return Component.text().content(lc.text());
        }
        if (contents instanceof TranslatableContents) {
            TranslatableContents tc = (TranslatableContents)contents;
            List<Component> argList = Arrays.stream(tc.getArgs()).map(arg -> {
                TextComponent textComponent;
                if (arg instanceof net.minecraft.network.chat.Component) {
                    net.minecraft.network.chat.Component argComponent = (net.minecraft.network.chat.Component)arg;
                    textComponent = SpongeAdventure.asAdventure(argComponent);
                } else {
                    textComponent = Component.text((String)arg.toString());
                }
                return textComponent;
            }).toList();
            return Component.translatable().key(tc.getKey()).args(argList);
        }
        if (contents instanceof KeybindContents) {
            KeybindContents kc = (KeybindContents)contents;
            return Component.keybind().keybind(kc.getName());
        }
        if (contents instanceof ScoreContents) {
            ScoreContents sc = (ScoreContents)contents;
            return Component.score().name(sc.getName()).objective(sc.getObjective());
        }
        if (contents instanceof SelectorContents) {
            SelectorContents sc = (SelectorContents)contents;
            return Component.selector().pattern(sc.getPattern()).separator((ComponentLike)SpongeAdventure.asAdventure(sc.getSeparator()));
        }
        if (contents instanceof NbtContents) {
            BlockNBTComponent.Builder nbtBuilder;
            NbtContents nc = (NbtContents)contents;
            DataSource dataSource = nc.getDataSource();
            if (dataSource instanceof BlockDataSource) {
                BlockDataSource ds = (BlockDataSource)dataSource;
                nbtBuilder = Component.blockNBT().pos(BlockNBTComponent.Pos.fromString((String)ds.posPattern()));
            } else {
                dataSource = nc.getDataSource();
                if (dataSource instanceof EntityDataSource) {
                    EntityDataSource ds = (EntityDataSource)dataSource;
                    nbtBuilder = Component.entityNBT().selector(ds.selectorPattern());
                } else {
                    dataSource = nc.getDataSource();
                    if (dataSource instanceof StorageDataSource) {
                        StorageDataSource ds = (StorageDataSource)dataSource;
                        nbtBuilder = Component.storageNBT().storage(SpongeAdventure.asAdventure(ds.id()));
                    } else {
                        throw new UnsupportedOperationException("Cannot convert NBTContents with DataSource " + nc.getDataSource().getClass());
                    }
                }
            }
            return nbtBuilder.nbtPath(nc.getNbtPath()).interpret(nc.isInterpreting()).separator((ComponentLike)SpongeAdventure.asAdventure(nc.getSeparator()));
        }
        if (contents == ComponentContents.EMPTY) {
            return Component.empty().toBuilder();
        }
        throw new UnsupportedOperationException("Cannot convert ComponentContents of type " + contents.getClass());
    }

    public static @Nullable Component asAdventure(Optional<net.minecraft.network.chat.Component> component) {
        return component.map(SpongeAdventure::asAdventure).orElse(null);
    }

    public static net.kyori.adventure.text.format.Style asAdventure(Style mcStyle) {
        net.minecraft.network.chat.ClickEvent clickEvent;
        Style.Builder builder = net.kyori.adventure.text.format.Style.style();
        StyleAccessor $access = (StyleAccessor)mcStyle;
        builder.font(SpongeAdventure.asAdventure($access.accessor$font()));
        builder.color(SpongeAdventure.asAdventure(mcStyle.getColor()));
        builder.decoration(TextDecoration.OBFUSCATED, TextDecoration.State.byBoolean((Boolean)$access.accessor$obfuscated()));
        builder.decoration(TextDecoration.BOLD, TextDecoration.State.byBoolean((Boolean)$access.accessor$bold()));
        builder.decoration(TextDecoration.STRIKETHROUGH, TextDecoration.State.byBoolean((Boolean)$access.accessor$strikethrough()));
        builder.decoration(TextDecoration.UNDERLINED, TextDecoration.State.byBoolean((Boolean)$access.accessor$underlined()));
        builder.decoration(TextDecoration.ITALIC, TextDecoration.State.byBoolean((Boolean)$access.accessor$italic()));
        net.minecraft.network.chat.HoverEvent hoverEvent = mcStyle.getHoverEvent();
        if (hoverEvent != null) {
            builder.hoverEvent(SpongeAdventure.asAdventure(hoverEvent));
        }
        if ((clickEvent = mcStyle.getClickEvent()) != null) {
            builder.clickEvent(ClickEvent.clickEvent((ClickEvent.Action)SpongeAdventure.asAdventure(clickEvent.getAction()), (String)clickEvent.getValue()));
        }
        builder.insertion(mcStyle.getInsertion());
        return builder.build();
    }

    public static Component asAdventure(Message message) {
        if (message instanceof net.minecraft.network.chat.Component) {
            return SpongeAdventure.asAdventure((net.minecraft.network.chat.Component)message);
        }
        if (message instanceof Component) {
            return (Component)message;
        }
        return Component.text((String)message.getString());
    }

    public static Style asVanilla(net.kyori.adventure.text.format.Style style) {
        return ((StyleBridge)style).bridge$asVanilla();
    }

    public static @Nullable net.minecraft.network.chat.TextColor asVanillaNullable(@Nullable TextColor color) {
        if (color == null) {
            return null;
        }
        return net.minecraft.network.chat.TextColor.fromRgb((int)color.value());
    }

    public static ChatFormatting asVanilla(NamedTextColor color) {
        if (color == NamedTextColor.BLACK) {
            return ChatFormatting.BLACK;
        }
        if (color == NamedTextColor.DARK_BLUE) {
            return ChatFormatting.DARK_BLUE;
        }
        if (color == NamedTextColor.DARK_GREEN) {
            return ChatFormatting.DARK_GREEN;
        }
        if (color == NamedTextColor.DARK_AQUA) {
            return ChatFormatting.DARK_AQUA;
        }
        if (color == NamedTextColor.DARK_RED) {
            return ChatFormatting.DARK_RED;
        }
        if (color == NamedTextColor.DARK_PURPLE) {
            return ChatFormatting.DARK_PURPLE;
        }
        if (color == NamedTextColor.GOLD) {
            return ChatFormatting.GOLD;
        }
        if (color == NamedTextColor.GRAY) {
            return ChatFormatting.GRAY;
        }
        if (color == NamedTextColor.DARK_GRAY) {
            return ChatFormatting.DARK_GRAY;
        }
        if (color == NamedTextColor.BLUE) {
            return ChatFormatting.BLUE;
        }
        if (color == NamedTextColor.GREEN) {
            return ChatFormatting.GREEN;
        }
        if (color == NamedTextColor.AQUA) {
            return ChatFormatting.AQUA;
        }
        if (color == NamedTextColor.RED) {
            return ChatFormatting.RED;
        }
        if (color == NamedTextColor.LIGHT_PURPLE) {
            return ChatFormatting.LIGHT_PURPLE;
        }
        if (color == NamedTextColor.YELLOW) {
            return ChatFormatting.YELLOW;
        }
        if (color == NamedTextColor.WHITE) {
            return ChatFormatting.WHITE;
        }
        throw new IllegalArgumentException();
    }

    public static @Nullable TextColor asAdventure(@Nullable net.minecraft.network.chat.TextColor color) {
        if (color == null) {
            return null;
        }
        return TextColor.color((int)color.getValue());
    }

    public static @Nullable TextColor asAdventure(ChatFormatting formatting) {
        if (formatting == null) {
            return null;
        }
        Integer color = formatting.getColor();
        if (color == null) {
            return null;
        }
        return TextColor.color((int)color);
    }

    public static @Nullable NamedTextColor asAdventureNamed(@Nullable ChatFormatting color) {
        if (color == null) {
            return null;
        }
        if (color == ChatFormatting.BLACK) {
            return NamedTextColor.BLACK;
        }
        if (color == ChatFormatting.DARK_BLUE) {
            return NamedTextColor.DARK_BLUE;
        }
        if (color == ChatFormatting.DARK_GREEN) {
            return NamedTextColor.DARK_GREEN;
        }
        if (color == ChatFormatting.DARK_AQUA) {
            return NamedTextColor.DARK_AQUA;
        }
        if (color == ChatFormatting.DARK_RED) {
            return NamedTextColor.DARK_RED;
        }
        if (color == ChatFormatting.DARK_PURPLE) {
            return NamedTextColor.DARK_PURPLE;
        }
        if (color == ChatFormatting.GOLD) {
            return NamedTextColor.GOLD;
        }
        if (color == ChatFormatting.GRAY) {
            return NamedTextColor.GRAY;
        }
        if (color == ChatFormatting.DARK_GRAY) {
            return NamedTextColor.DARK_GRAY;
        }
        if (color == ChatFormatting.BLUE) {
            return NamedTextColor.BLUE;
        }
        if (color == ChatFormatting.GREEN) {
            return NamedTextColor.GREEN;
        }
        if (color == ChatFormatting.AQUA) {
            return NamedTextColor.AQUA;
        }
        if (color == ChatFormatting.RED) {
            return NamedTextColor.RED;
        }
        if (color == ChatFormatting.LIGHT_PURPLE) {
            return NamedTextColor.LIGHT_PURPLE;
        }
        if (color == ChatFormatting.YELLOW) {
            return NamedTextColor.YELLOW;
        }
        return NamedTextColor.WHITE;
    }

    public static @Nullable Boolean asVanillaNullable(TextDecoration.State state) {
        if (state == TextDecoration.State.TRUE) {
            return true;
        }
        if (state == TextDecoration.State.FALSE) {
            return false;
        }
        return null;
    }

    public static ChatType.Bound asVanilla(MessageType type, RegistryAccess registryAccess, net.minecraft.network.chat.Component name) {
        if (type == MessageType.CHAT) {
            return ChatType.bind((ResourceKey)ChatType.CHAT, (RegistryAccess)registryAccess, (net.minecraft.network.chat.Component)name);
        }
        throw new IllegalArgumentException(type.name());
    }

    public static HoverEvent<?> asAdventure(net.minecraft.network.chat.HoverEvent event) {
        HoverEvent.Action action = event.getAction();
        if (action == HoverEvent.Action.SHOW_TEXT) {
            return HoverEvent.showText((Component)SpongeAdventure.asAdventure((net.minecraft.network.chat.Component)event.getValue(HoverEvent.Action.SHOW_TEXT)));
        }
        if (action == HoverEvent.Action.SHOW_ENTITY) {
            HoverEvent.EntityTooltipInfo value = (HoverEvent.EntityTooltipInfo)event.getValue(HoverEvent.Action.SHOW_ENTITY);
            Registry entityTypeRegistry = SpongeCommon.vanillaRegistry(Registries.ENTITY_TYPE);
            return HoverEvent.showEntity((Key)SpongeAdventure.asAdventure(entityTypeRegistry.getKey((Object)value.type)), (UUID)value.id, (Component)SpongeAdventure.asAdventure(value.name));
        }
        if (action == HoverEvent.Action.SHOW_ITEM) {
            HoverEvent.ItemStackInfo value = (HoverEvent.ItemStackInfo)event.getValue(HoverEvent.Action.SHOW_ITEM);
            Registry itemRegistry = SpongeCommon.vanillaRegistry(Registries.ITEM);
            return HoverEvent.showItem((Key)SpongeAdventure.asAdventure(itemRegistry.getKey((Object)((HoverEvent_ItemStackInfoAccessor)value).accessor$item())), (int)((HoverEvent_ItemStackInfoAccessor)value).accessor$count(), (BinaryTagHolder)SpongeAdventure.asBinaryTagHolder(((HoverEvent_ItemStackInfoAccessor)value).accessor$tag()));
        }
        throw new IllegalArgumentException(event.toString());
    }

    public static @Nullable net.minecraft.network.chat.ClickEvent asVanillaNullable(@Nullable ClickEvent event) {
        if (event == null) {
            return null;
        }
        return new net.minecraft.network.chat.ClickEvent(SpongeAdventure.asVanilla(event.action()), event.value());
    }

    public static @Nullable net.minecraft.network.chat.HoverEvent asVanillaNullable(@Nullable HoverEvent<?> event) {
        if (event == null) {
            return null;
        }
        HoverEvent.Action action = event.action();
        if (action == HoverEvent.Action.SHOW_TEXT) {
            return new net.minecraft.network.chat.HoverEvent(HoverEvent.Action.SHOW_TEXT, (Object)SpongeAdventure.asVanilla((Component)event.value()));
        }
        if (action == HoverEvent.Action.SHOW_ENTITY) {
            HoverEvent.ShowEntity value = (HoverEvent.ShowEntity)event.value();
            Registry entityTypeRegistry = SpongeCommon.vanillaRegistry(Registries.ENTITY_TYPE);
            return new net.minecraft.network.chat.HoverEvent(HoverEvent.Action.SHOW_ENTITY, (Object)new HoverEvent.EntityTooltipInfo((EntityType)entityTypeRegistry.get(SpongeAdventure.asVanilla(value.type())), value.id(), SpongeAdventure.asVanillaNullable(value.name())));
        }
        if (action == HoverEvent.Action.SHOW_ITEM) {
            HoverEvent.ShowItem value = (HoverEvent.ShowItem)event.value();
            Registry itemRegistry = SpongeCommon.vanillaRegistry(Registries.ITEM);
            return new net.minecraft.network.chat.HoverEvent(HoverEvent.Action.SHOW_ITEM, (Object)HoverEvent_ItemStackInfoAccessor.invoker$new((Item)itemRegistry.get(SpongeAdventure.asVanilla(value.item())), value.count(), SpongeAdventure.asVanillaCompound(value.nbt())));
        }
        throw new IllegalArgumentException(event.toString());
    }

    public static HoverEvent.Action<?> asVanilla(HoverEvent.Action<?> action) {
        if (action == HoverEvent.Action.SHOW_TEXT) {
            return HoverEvent.Action.SHOW_TEXT;
        }
        if (action == HoverEvent.Action.SHOW_ITEM) {
            return HoverEvent.Action.SHOW_ITEM;
        }
        if (action == HoverEvent.Action.SHOW_ENTITY) {
            return HoverEvent.Action.SHOW_ENTITY;
        }
        throw new IllegalArgumentException(action.toString());
    }

    public static ClickEvent.Action asAdventure(ClickEvent.Action action) {
        if (action == ClickEvent.Action.OPEN_URL) {
            return ClickEvent.Action.OPEN_URL;
        }
        if (action == ClickEvent.Action.OPEN_FILE) {
            return ClickEvent.Action.OPEN_FILE;
        }
        if (action == ClickEvent.Action.RUN_COMMAND) {
            return ClickEvent.Action.RUN_COMMAND;
        }
        if (action == ClickEvent.Action.SUGGEST_COMMAND) {
            return ClickEvent.Action.SUGGEST_COMMAND;
        }
        if (action == ClickEvent.Action.CHANGE_PAGE) {
            return ClickEvent.Action.CHANGE_PAGE;
        }
        throw new IllegalArgumentException(action.toString());
    }

    public static ClickEvent.Action asVanilla(ClickEvent.Action action) {
        if (action == ClickEvent.Action.OPEN_URL) {
            return ClickEvent.Action.OPEN_URL;
        }
        if (action == ClickEvent.Action.OPEN_FILE) {
            return ClickEvent.Action.OPEN_FILE;
        }
        if (action == ClickEvent.Action.RUN_COMMAND) {
            return ClickEvent.Action.RUN_COMMAND;
        }
        if (action == ClickEvent.Action.SUGGEST_COMMAND) {
            return ClickEvent.Action.SUGGEST_COMMAND;
        }
        if (action == ClickEvent.Action.CHANGE_PAGE) {
            return ClickEvent.Action.CHANGE_PAGE;
        }
        if (action == ClickEvent.Action.COPY_TO_CLIPBOARD) {
            return ClickEvent.Action.COPY_TO_CLIPBOARD;
        }
        throw new IllegalArgumentException(action.toString());
    }

    public static List<Component> json(List<String> strings) {
        GsonComponentSerializer gcs = GsonComponentSerializer.gson();
        ArrayList<Component> components = new ArrayList<Component>();
        for (String string : strings) {
            components.add(gcs.deserialize((Object)string));
        }
        return components;
    }

    public static ListTag listTagJson(List<Component> components) {
        GsonComponentSerializer gcs = GsonComponentSerializer.gson();
        ListTag nbt = new ListTag();
        for (Component component : components) {
            nbt.add((Object)StringTag.valueOf((String)((String)gcs.serialize(component))));
        }
        return nbt;
    }

    public static BossBar asAdventure(BossEvent bar) {
        return ((BossEventBridge)bar).bridge$asAdventure();
    }

    public static ServerBossEvent asVanillaServer(BossBar bar) {
        return ((BossBarBridge)bar).bridge$asVanillaServerBar();
    }

    public static BossEvent.BossBarColor asVanilla(BossBar.Color color) {
        if (color == BossBar.Color.PINK) {
            return BossEvent.BossBarColor.PINK;
        }
        if (color == BossBar.Color.BLUE) {
            return BossEvent.BossBarColor.BLUE;
        }
        if (color == BossBar.Color.RED) {
            return BossEvent.BossBarColor.RED;
        }
        if (color == BossBar.Color.GREEN) {
            return BossEvent.BossBarColor.GREEN;
        }
        if (color == BossBar.Color.YELLOW) {
            return BossEvent.BossBarColor.YELLOW;
        }
        if (color == BossBar.Color.PURPLE) {
            return BossEvent.BossBarColor.PURPLE;
        }
        if (color == BossBar.Color.WHITE) {
            return BossEvent.BossBarColor.WHITE;
        }
        throw new IllegalArgumentException(color.name());
    }

    public static BossBar.Color asAdventure(BossEvent.BossBarColor color) {
        if (color == BossEvent.BossBarColor.PINK) {
            return BossBar.Color.PINK;
        }
        if (color == BossEvent.BossBarColor.BLUE) {
            return BossBar.Color.BLUE;
        }
        if (color == BossEvent.BossBarColor.RED) {
            return BossBar.Color.RED;
        }
        if (color == BossEvent.BossBarColor.GREEN) {
            return BossBar.Color.GREEN;
        }
        if (color == BossEvent.BossBarColor.YELLOW) {
            return BossBar.Color.YELLOW;
        }
        if (color == BossEvent.BossBarColor.PURPLE) {
            return BossBar.Color.PURPLE;
        }
        if (color == BossEvent.BossBarColor.WHITE) {
            return BossBar.Color.WHITE;
        }
        throw new IllegalArgumentException(color.name());
    }

    public static BossEvent.BossBarOverlay asVanilla(BossBar.Overlay overlay) {
        if (overlay == BossBar.Overlay.PROGRESS) {
            return BossEvent.BossBarOverlay.PROGRESS;
        }
        if (overlay == BossBar.Overlay.NOTCHED_6) {
            return BossEvent.BossBarOverlay.NOTCHED_6;
        }
        if (overlay == BossBar.Overlay.NOTCHED_10) {
            return BossEvent.BossBarOverlay.NOTCHED_10;
        }
        if (overlay == BossBar.Overlay.NOTCHED_12) {
            return BossEvent.BossBarOverlay.NOTCHED_12;
        }
        if (overlay == BossBar.Overlay.NOTCHED_20) {
            return BossEvent.BossBarOverlay.NOTCHED_20;
        }
        throw new IllegalArgumentException(overlay.name());
    }

    public static BossBar.Overlay asAdventure(BossEvent.BossBarOverlay overlay) {
        if (overlay == BossEvent.BossBarOverlay.PROGRESS) {
            return BossBar.Overlay.PROGRESS;
        }
        if (overlay == BossEvent.BossBarOverlay.NOTCHED_6) {
            return BossBar.Overlay.NOTCHED_6;
        }
        if (overlay == BossEvent.BossBarOverlay.NOTCHED_10) {
            return BossBar.Overlay.NOTCHED_10;
        }
        if (overlay == BossEvent.BossBarOverlay.NOTCHED_12) {
            return BossBar.Overlay.NOTCHED_12;
        }
        if (overlay == BossEvent.BossBarOverlay.NOTCHED_20) {
            return BossBar.Overlay.NOTCHED_20;
        }
        throw new IllegalArgumentException(overlay.name());
    }

    public static Set<BossBar.Flag> asAdventureFlags(boolean darkenScreen, boolean playBossMusic, boolean createWorldFog) {
        EnumSet<BossBar.Flag> flags = EnumSet.noneOf(BossBar.Flag.class);
        if (darkenScreen) {
            flags.add(BossBar.Flag.DARKEN_SCREEN);
        }
        if (playBossMusic) {
            flags.add(BossBar.Flag.PLAY_BOSS_MUSIC);
        }
        if (createWorldFog) {
            flags.add(BossBar.Flag.CREATE_WORLD_FOG);
        }
        return flags;
    }

    public static @Nullable CompoundTag asVanillaCompound(@Nullable BinaryTagHolder tag) {
        if (tag == null) {
            return null;
        }
        try {
            return (CompoundTag)tag.get(NBT_CODEC);
        }
        catch (IOException e) {
            return null;
        }
    }

    public static @Nullable BinaryTagHolder asBinaryTagHolder(@Nullable CompoundTag tag) {
        if (tag == null) {
            return null;
        }
        try {
            return BinaryTagHolder.encode((Object)tag, NBT_CODEC);
        }
        catch (IOException e) {
            return null;
        }
    }

    public static ResourceLocation asVanilla(Key key) {
        if (key instanceof ResourceLocation) {
            return (ResourceLocation)key;
        }
        return new ResourceLocation(key.namespace(), key.value());
    }

    public static @Nullable ResourceLocation asVanillaNullable(@Nullable Key key) {
        if (key == null) {
            return null;
        }
        return SpongeAdventure.asVanilla(key);
    }

    public static Sound.Source asAdventure(SoundSource source) {
        switch (source) {
            case MASTER: {
                return Sound.Source.MASTER;
            }
            case MUSIC: {
                return Sound.Source.MUSIC;
            }
            case RECORDS: {
                return Sound.Source.RECORD;
            }
            case WEATHER: {
                return Sound.Source.WEATHER;
            }
            case BLOCKS: {
                return Sound.Source.BLOCK;
            }
            case HOSTILE: {
                return Sound.Source.HOSTILE;
            }
            case NEUTRAL: {
                return Sound.Source.NEUTRAL;
            }
            case PLAYERS: {
                return Sound.Source.PLAYER;
            }
            case AMBIENT: {
                return Sound.Source.AMBIENT;
            }
            case VOICE: {
                return Sound.Source.VOICE;
            }
        }
        throw new IllegalArgumentException(source.name());
    }

    public static SoundSource asVanilla(Sound.Source source) {
        switch (source) {
            case MASTER: {
                return SoundSource.MASTER;
            }
            case MUSIC: {
                return SoundSource.MUSIC;
            }
            case RECORD: {
                return SoundSource.RECORDS;
            }
            case WEATHER: {
                return SoundSource.WEATHER;
            }
            case BLOCK: {
                return SoundSource.BLOCKS;
            }
            case HOSTILE: {
                return SoundSource.HOSTILE;
            }
            case NEUTRAL: {
                return SoundSource.NEUTRAL;
            }
            case PLAYER: {
                return SoundSource.PLAYERS;
            }
            case AMBIENT: {
                return SoundSource.AMBIENT;
            }
            case VOICE: {
                return SoundSource.VOICE;
            }
        }
        throw new IllegalArgumentException(source.name());
    }

    public static @Nullable SoundSource asVanillaNullable(// Could not load outer class - annotation placement on inner may be incorrect
     @Nullable Sound.Source source) {
        if (source == null) {
            return null;
        }
        return SpongeAdventure.asVanilla(source);
    }

    public static Iterable<? extends Audience> unpackAudiences(Audience audience) {
        if (audience instanceof ForwardingAudience) {
            ArrayList list = new ArrayList();
            for (Audience subAudience : ((ForwardingAudience)audience).audiences()) {
                SpongeAdventure.unpackAudiences(subAudience).forEach(list::add);
            }
            return list;
        }
        return Collections.singletonList(audience);
    }

    public static void registerBossBar(ServerBossEvent mcBar) {
        ACTIVE_BOSS_BARS.add(mcBar);
    }

    public static void unregisterBossBar(ServerBossEvent mcBar) {
        ACTIVE_BOSS_BARS.remove(mcBar);
    }

    public static void forEachBossBar(Consumer<ServerBossEvent> info) {
        ACTIVE_BOSS_BARS.forEach(info);
    }

    public static class Factory
    implements SpongeComponents.Factory {
        @Override
        public @NonNull ClickEvent callbackClickEvent(@NonNull Consumer<CommandCause> callback) {
            Objects.requireNonNull(callback);
            UUID key = CallbackCommand.INSTANCE.registerCallback(callback);
            return ClickEvent.runCommand((String)String.format("/%s:%s %s", ((Launch)Launch.instance()).id(), "callback", key));
        }

        @Override
        @SafeVarargs
        public final @NonNull Component render(@NonNull Component component, @NonNull CommandCause senderContext, @Nullable Audience viewer, @NonNull DefaultedRegistryReference<ResolveOperation> firstOperation, DefaultedRegistryReference<ResolveOperation> ... otherOperations) {
            Component output = Objects.requireNonNull(component, "component");
            Objects.requireNonNull(senderContext, "senderContext");
            while (viewer instanceof ForwardingAudience.Single && !(viewer instanceof Entity)) {
                viewer = ((ForwardingAudience.Single)viewer).audience();
            }
            Entity backing = viewer instanceof Entity ? (Entity)viewer : null;
            output = ((SpongeResolveOperation)Objects.requireNonNull(firstOperation, "firstOperation").get()).resolve(output, senderContext, backing);
            for (DefaultedRegistryReference<ResolveOperation> ref : otherOperations) {
                output = ((SpongeResolveOperation)ref.get()).resolve(output, senderContext, backing);
            }
            return output;
        }

        @Override
        @SafeVarargs
        public final @NonNull Component render(@NonNull Component component, @NonNull CommandCause senderContext, @NonNull DefaultedRegistryReference<ResolveOperation> firstOperation, DefaultedRegistryReference<ResolveOperation> ... otherOperations) {
            return this.render(component, senderContext, (Audience)null, firstOperation, otherOperations);
        }

        @Override
        public ComponentFlattener flattener() {
            return ComponentFlattenerProvider.INSTANCE;
        }
    }
}

