/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.command.registrar.tree.key;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.DoubleArgumentType;
import com.mojang.brigadier.arguments.FloatArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.LongArgumentType;
import java.util.function.BiFunction;
import net.minecraft.commands.synchronization.ArgumentTypeInfo;
import net.minecraft.commands.synchronization.brigadier.DoubleArgumentInfo;
import net.minecraft.commands.synchronization.brigadier.FloatArgumentInfo;
import net.minecraft.commands.synchronization.brigadier.IntegerArgumentInfo;
import net.minecraft.commands.synchronization.brigadier.LongArgumentInfo;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.ResourceKey;
import org.spongepowered.api.command.registrar.tree.CommandTreeNode;
import org.spongepowered.api.command.registrar.tree.CommandTreeNodeType;
import org.spongepowered.common.AbstractResourceKeyed;
import org.spongepowered.common.command.registrar.tree.builder.RangeCommandTreeNode;

public final class SpongeRangeCommandTreeNodeType<N extends Number>
extends AbstractResourceKeyed
implements CommandTreeNodeType<CommandTreeNode.Range<N>> {
    private final BiFunction<N, N, ArgumentType<?>> typeCreator;
    private final N min;
    private final N max;

    public static @Nullable SpongeRangeCommandTreeNodeType<?> createFrom(ResourceKey key, ArgumentTypeInfo<?, ?> serializer) {
        if (serializer instanceof FloatArgumentInfo) {
            return new SpongeRangeCommandTreeNodeType<Float>(key, FloatArgumentType::floatArg, Float.valueOf(Float.MIN_VALUE), Float.valueOf(Float.MAX_VALUE));
        }
        if (serializer instanceof DoubleArgumentInfo) {
            return new SpongeRangeCommandTreeNodeType<Double>(key, DoubleArgumentType::doubleArg, (Double)Double.MIN_VALUE, (Double)Double.MAX_VALUE);
        }
        if (serializer instanceof IntegerArgumentInfo) {
            return new SpongeRangeCommandTreeNodeType<Integer>(key, IntegerArgumentType::integer, Integer.MIN_VALUE, Integer.MAX_VALUE);
        }
        if (serializer instanceof LongArgumentInfo) {
            return new SpongeRangeCommandTreeNodeType<Long>(key, LongArgumentType::longArg, Long.MIN_VALUE, Long.MAX_VALUE);
        }
        return null;
    }

    private SpongeRangeCommandTreeNodeType(ResourceKey key, BiFunction<N, N, ArgumentType<?>> typeCreator, N min, N max) {
        super(key);
        this.typeCreator = typeCreator;
        this.min = min;
        this.max = max;
    }

    @Override
    public  @NonNull CommandTreeNode.Range<@NonNull N> createNode() {
        return new RangeCommandTreeNode<N>(this, this.typeCreator, this.min, this.max);
    }
}

