/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.data.provider.block.entity;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.kyori.adventure.text.Component;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.StandingSignBlock;
import net.minecraft.world.level.block.WallSignBlock;
import net.minecraft.world.level.block.entity.SignBlockEntity;
import net.minecraft.world.level.block.entity.SignText;
import net.minecraft.world.level.block.state.properties.Property;
import org.spongepowered.api.block.entity.Sign;
import org.spongepowered.api.data.Keys;
import org.spongepowered.api.world.server.ServerLocation;
import org.spongepowered.common.adventure.SpongeAdventure;
import org.spongepowered.common.data.provider.DataProviderRegistrator;
import org.spongepowered.common.util.DirectionUtil;
import org.spongepowered.common.util.RotationUtils;

public final class SignData {
    private static final boolean FRONT_SIGN = true;
    private static final boolean BACK_SIGN = false;

    private SignData() {
    }

    public static void register(DataProviderRegistrator registrator) {
        ((DataProviderRegistrator.MutableRegistration)((DataProviderRegistrator.MutableRegistration)((DataProviderRegistrator.MutableRegistration)((DataProviderRegistrator.MutableRegistration)((DataProviderRegistrator.MutableRegistration)((DataProviderRegistrator.MutableRegistration)((DataProviderRegistrator.MutableRegistration)((DataProviderRegistrator.MutableRegistration)((DataProviderRegistrator.MutableRegistration)((DataProviderRegistrator.MutableRegistration)((DataProviderRegistrator.MutableRegistration)((DataProviderRegistrator.MutableRegistration)((DataProviderRegistrator.MutableRegistration)((DataProviderRegistrator.MutableRegistration)((DataProviderRegistrator.MutableRegistration)((DataProviderRegistrator.MutableRegistration)((DataProviderRegistrator.MutableRegistration)((DataProviderRegistrator.MutableRegistration)((DataProviderRegistrator.MutableRegistration)((DataProviderRegistrator.MutableRegistration)((DataProviderRegistrator.MutableRegistration)((DataProviderRegistrator.MutableRegistration)registrator.asMutable(SignBlockEntity.class).create(Keys.SIGN_LINES).get(SignData::getSignLines)).set(SignData::setSignLines)).delete(h -> SignData.setSignLines(h, Collections.emptyList()))).create(Keys.DIRECTION).get(h -> {
            if (h.getBlockState().getBlock() instanceof StandingSignBlock) {
                return RotationUtils.getFor((Integer)h.getBlockState().getValue((Property)StandingSignBlock.ROTATION));
            }
            if (h.getBlockState().getBlock() instanceof WallSignBlock) {
                return DirectionUtil.getFor((Direction)h.getBlockState().getValue((Property)WallSignBlock.FACING));
            }
            return null;
        })).setAnd((h, v) -> {
            if (h.getBlockState().getBlock() instanceof StandingSignBlock) {
                h.getLevel().setBlockAndUpdate(h.getBlockPos(), RotationUtils.set(h.getBlockState(), v, (Property<Integer>)StandingSignBlock.ROTATION));
                return true;
            }
            if (h.getBlockState().getBlock() instanceof WallSignBlock) {
                h.getLevel().setBlockAndUpdate(h.getBlockPos(), DirectionUtil.set(h.getBlockState(), v, WallSignBlock.FACING));
                return true;
            }
            return false;
        })).supports(h -> h.getLevel() != null)).create(Keys.GLOWING_TEXT).get(h -> h.getFrontText().hasGlowingText())).set((h, v) -> h.updateText(text -> text.setHasGlowingText(v.booleanValue()), true))).create(Keys.SIGN_FRONT_TEXT).get(h -> (Sign.SignText)h.getFrontText())).set((h, v) -> h.setText((SignText)v, true))).create(Keys.SIGN_BACK_TEXT).get(h -> (Sign.SignText)h.getBackText())).set((h, v) -> h.setText((SignText)v, false))).create(Keys.SIGN_WAXED).get(SignBlockEntity::isWaxed)).set(SignBlockEntity::setWaxed)).asMutable(ServerLocation.class).create(Keys.SIGN_LINES).get(SignData::getSignLines)).set(SignData::setSignLines)).delete(h -> SignData.setSignLines(h, Collections.emptyList()))).supports(loc -> loc.blockEntity().map(b -> b instanceof SignBlockEntity).orElse(false))).asMutable(SignText.class).create(Keys.SIGN_LINES).get(SignData::getSignLines)).set(SignData::setSignLines)).delete(h -> SignData.setSignLines(h, Collections.emptyList()))).create(Keys.GLOWING_TEXT).get(SignText::hasGlowingText)).set(SignText::setHasGlowingText);
    }

    private static SignBlockEntity toSignTileEntity(ServerLocation holder) {
        return (SignBlockEntity)holder.blockEntity().get();
    }

    private static void setSignLines(ServerLocation holder, List<Component> value) {
        SignData.setSignLines(SignData.toSignTileEntity(holder), value);
    }

    private static void setSignLines(SignBlockEntity holder, List<Component> value) {
        holder.updateText(signText -> SignData.setSignLines(signText, value), true);
    }

    private static SignText setSignLines(SignText holder, List<Component> value) {
        for (int i = 0; i < holder.getMessages(true).length; ++i) {
            holder = holder.setMessage(i, SpongeAdventure.asVanilla((Component)(i > value.size() - 1 ? Component.empty() : value.get(i))));
        }
        return holder;
    }

    private static List<Component> getSignLines(ServerLocation h) {
        return SignData.getSignLines(SignData.toSignTileEntity(h));
    }

    private static List<Component> getSignLines(SignBlockEntity holder) {
        return SignData.getSignLines(holder.getFrontText());
    }

    private static List<Component> getSignLines(SignText holder) {
        ArrayList<Component> lines = new ArrayList<Component>();
        for (int i = 0; i < holder.getMessages(true).length; ++i) {
            lines.add(SpongeAdventure.asAdventure(holder.getMessage(i, true)));
        }
        return lines;
    }
}

