/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.data.provider.item.stack;

import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import org.spongepowered.api.block.BlockType;
import org.spongepowered.api.data.Keys;
import org.spongepowered.common.SpongeCommon;
import org.spongepowered.common.data.provider.DataProviderRegistrator;
import org.spongepowered.common.util.NBTCollectors;
import org.spongepowered.common.util.NBTStreams;

public final class BlockTypeItemStackData {
    private BlockTypeItemStackData() {
    }

    public static void register(DataProviderRegistrator registrator) {
        ((DataProviderRegistrator.MutableRegistration)((DataProviderRegistrator.MutableRegistration)((DataProviderRegistrator.MutableRegistration)registrator.asMutable(ItemStack.class).create(Keys.BREAKABLE_BLOCK_TYPES).get(h -> BlockTypeItemStackData.get(h, "CanDestroy"))).set((h, v) -> BlockTypeItemStackData.set(h, "CanDestroy", v))).create(Keys.PLACEABLE_BLOCK_TYPES).get(h -> BlockTypeItemStackData.get(h, "CanPlaceOn"))).set((h, v) -> BlockTypeItemStackData.set(h, "CanPlaceOn", v));
    }

    private static Set<BlockType> get(ItemStack stack, String nbtKey) {
        CompoundTag tag = stack.getTag();
        if (tag == null) {
            return null;
        }
        ListTag list = tag.getList(nbtKey, 8);
        if (list.isEmpty()) {
            return null;
        }
        Registry blockRegistry = SpongeCommon.vanillaRegistry(Registries.BLOCK);
        return NBTStreams.toStrings((Iterable<Tag>)list).map(ResourceLocation::tryParse).filter(Objects::nonNull).map(key -> blockRegistry.getOptional(key).orElse(null)).filter(Objects::nonNull).collect(Collectors.toSet());
    }

    private static boolean set(ItemStack stack, String nbtKey, Set<? extends BlockType> value) {
        if (value.isEmpty()) {
            stack.removeTagKey(nbtKey);
            return true;
        }
        Registry blockRegistry = SpongeCommon.vanillaRegistry(Registries.BLOCK);
        CompoundTag tag = stack.getOrCreateTag();
        ListTag list = value.stream().map(type -> blockRegistry.getKey((Object)((Block)type)).toString()).collect(NBTCollectors.toStringTagList());
        tag.put(nbtKey, (Tag)list);
        return true;
    }
}

