/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.datapack.recipe;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import net.minecraft.advancements.AdvancementHolder;
import net.minecraft.data.recipes.FinishedRecipe;
import org.spongepowered.api.item.recipe.RecipeRegistration;
import org.spongepowered.common.datapack.DataPackDecoder;
import org.spongepowered.common.datapack.DataPackEncoder;
import org.spongepowered.common.datapack.JsonDataPackSerializer;
import org.spongepowered.common.datapack.SpongeDataPack;

public final class RecipeDataPackSerializer
extends JsonDataPackSerializer<RecipeRegistration> {
    public RecipeDataPackSerializer(DataPackEncoder<JsonElement, RecipeRegistration> encoder, DataPackDecoder<JsonElement, RecipeRegistration> decoder) {
        super(encoder, decoder);
    }

    @Override
    protected void serializeAdditional(SpongeDataPack<JsonElement, RecipeRegistration> type, Path packDir, RecipeRegistration entry) throws IOException {
        AdvancementHolder advancement = ((FinishedRecipe)entry).advancement();
        if (advancement != null) {
            JsonObject advancementJson = advancement.value().serializeToJson();
            Path file = packDir.resolve("data").resolve(entry.key().namespace()).resolve("advancements").resolve(entry.key().value() + ".json");
            Files.createDirectories(file.getParent(), new FileAttribute[0]);
            JsonDataPackSerializer.writeFile(file, advancementJson);
        }
    }
}

