/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.effect.record;

import com.google.common.base.Preconditions;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.protocol.game.ClientboundLevelEventPacket;
import net.minecraft.world.item.RecordItem;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.effect.sound.SoundType;
import org.spongepowered.api.effect.sound.music.MusicDisc;
import org.spongepowered.common.accessor.world.item.RecordItemAccessor;
import org.spongepowered.math.vector.Vector3i;

public final class SpongeMusicDisc
implements MusicDisc {
    private static final int EFFECT_ID = 1010;
    private final RecordItem item;
    private final int id;

    public SpongeMusicDisc(RecordItem item) {
        this.item = item;
        this.id = BuiltInRegistries.ITEM.getId((Object)item);
    }

    public int getId() {
        return this.id;
    }

    @Override
    public SoundType sound() {
        return (SoundType)((RecordItemAccessor)this.item).accessor$sound();
    }

    public static ClientboundLevelEventPacket createPacket(Vector3i position, @Nullable MusicDisc recordType) {
        Preconditions.checkNotNull((Object)position, (Object)"position");
        BlockPos pos = new BlockPos(position.x(), position.y(), position.z());
        return new ClientboundLevelEventPacket(1010, pos, recordType == null ? 0 : ((SpongeMusicDisc)recordType).getId(), false);
    }
}

